/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.load.MethodName;
import org.simpleframework.xml.load.MethodPart;
import org.simpleframework.xml.load.MethodType;
import org.simpleframework.xml.load.Reflector;

class GetPart
implements MethodPart {
    private final Annotation label;
    private final MethodType type;
    private final Method method;
    private final String name;

    public GetPart(MethodName method, Annotation label) {
        this.method = method.getMethod();
        this.name = method.getName();
        this.type = method.getType();
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.method.getReturnType();
    }

    public Class getDependant() {
        return Reflector.getReturnDependant(this.method);
    }

    public Class[] getDependants() {
        return Reflector.getReturnDependants(this.method);
    }

    public Annotation getAnnotation() {
        return this.label;
    }

    public MethodType getMethodType() {
        return this.type;
    }

    public Method getMethod() {
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        return this.method;
    }

    public String toString() {
        return this.method.toGenericString();
    }
}

