/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Scanner;
import org.simpleframework.xml.load.ScannerFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.transform.Transformer;

abstract class Factory {
    protected static Transformer transform = new Transformer();
    protected Source source;
    protected Class field;

    protected Factory(Source source, Class field) {
        this.source = source;
        this.field = field;
    }

    public Object getInstance() throws Exception {
        return this.field.newInstance();
    }

    public Type getOverride(InputNode node) throws Exception {
        Class real;
        Type type = this.getConversion(node);
        if (type != null && !Factory.isCompatible(this.field, real = type.getType())) {
            throw new InstantiationException("Type %s is not compatible with %s", real, this.field);
        }
        return type;
    }

    public boolean setOverride(Class field, Object value, OutputNode node) throws Exception {
        if (!field.isPrimitive()) {
            return this.source.setOverride(field, value, node);
        }
        return false;
    }

    public Type getConversion(InputNode node) throws Exception {
        return this.source.getOverride(this.field, node);
    }

    private static Scanner getScanner(Class type) throws Exception {
        return ScannerFactory.getInstance(type);
    }

    public static String getName(Class type) throws Exception {
        Scanner schema = Factory.getScanner(type);
        String name = schema.getName();
        if (name != null) {
            return name;
        }
        return Factory.getClassName(type);
    }

    public static String getClassName(Class type) throws Exception {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        String name = type.getSimpleName();
        if (type.isPrimitive()) {
            return name;
        }
        return Introspector.decapitalize(name);
    }

    public static boolean isPrimitive(Class type) throws Exception {
        if (type.isEnum()) {
            return true;
        }
        return transform.valid(type);
    }

    public static boolean isCompatible(Class field, Class type) {
        if (field.isArray()) {
            field = field.getComponentType();
        }
        return field.isAssignableFrom(type);
    }

    public static boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        return !Modifier.isInterface(modifiers);
    }
}

