/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeValue
implements Converter {
    private final Traverser root;
    private final Entry entry;
    private final Class type;

    public CompositeValue(Source root, Entry entry, Class type) throws Exception {
        this.root = new Traverser(root);
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        InputNode next = node.getNext();
        if (next == null) {
            return null;
        }
        if (next.isEmpty()) {
            return null;
        }
        return this.root.read(next, this.type);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String name) throws Exception {
        InputNode next = node.getNext(name);
        if (next == null) {
            return true;
        }
        if (next.isEmpty()) {
            return true;
        }
        return this.root.validate(next, this.type);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        this.root.write(node, item, this.type, name);
    }
}

