/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.Map;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.MapFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeMap
implements Converter {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Entry entry;

    public CompositeMap(Source root, Entry entry, Class type) throws Exception {
        this.factory = new MapFactory(root, type);
        this.value = entry.getValue(root);
        this.key = entry.getKey(root);
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object map = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, map);
        }
        return map;
    }

    private Object read(InputNode node, Object result) throws Exception {
        Map map = (Map)result;
        InputNode next;
        while ((next = node.getNext()) != null) {
            Object index = this.key.read(next);
            Object item = this.value.read(next);
            map.put(index, item);
        }
        return map;
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        InputNode next;
        do {
            if ((next = node.getNext()) == null) {
                return true;
            }
            if (this.key.validate(next)) continue;
            return false;
        } while (this.value.validate(next));
        return false;
    }

    public void write(OutputNode node, Object source) throws Exception {
        Map map = (Map)source;
        for (Object index : map.keySet()) {
            String name = this.entry.getEntry();
            OutputNode next = node.getChild(name);
            Object item = map.get(index);
            this.key.write(next, index);
            this.value.write(next, item);
        }
    }
}

