/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.load.AttributeException;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.Primitive;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;

class AttributeLabel
implements Label {
    private Attribute label;
    private Signature detail;
    private Class type;
    private String name;
    private String empty;

    public AttributeLabel(Contact contact, Attribute label) {
        this.detail = new Signature(contact, this);
        this.type = contact.getType();
        this.empty = label.empty();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        String ignore = this.getEmpty(root);
        if (!Factory.isPrimitive(this.type)) {
            throw new AttributeException("Cannot use %s to represent %s", this.label, this.type);
        }
        return new Primitive(root, this.type, ignore);
    }

    public String getEmpty(Source root) {
        if (this.detail.isEmpty(this.empty)) {
            return null;
        }
        return this.empty;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public String getOverride() {
        return this.name;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public Class getType() {
        return this.type;
    }

    public String getEntry() {
        return null;
    }

    public Class getDependant() {
        return null;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return false;
    }

    public boolean isInline() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

