/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.reflect.Array;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;

class ArrayFactory
extends Factory {
    public ArrayFactory(Source root, Class field) {
        super(root, field);
    }

    public Object getInstance() throws Exception {
        Class<?> type = this.field.getComponentType();
        if (type != null) {
            return Array.newInstance(type, 0);
        }
        return null;
    }

    public Type getInstance(InputNode node) throws Exception {
        Type type = this.getOverride(node);
        if (type == null) {
            throw new ElementException("Array length required for %s", this.field);
        }
        Class entry = type.getType();
        return this.getInstance(type, entry);
    }

    private Type getInstance(Type type, Class entry) throws Exception {
        Class<?> expect = this.field.getComponentType();
        if (!expect.isAssignableFrom(entry)) {
            throw new InstantiationException("Array of type %s cannot hold %s", expect, entry);
        }
        return type;
    }
}

