/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.simpleframework.xml.util.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver<M extends Match>
extends AbstractSet<M> {
    private Cache cache;
    private Stack stack = new Stack();

    public Resolver() {
        this.cache = new Cache();
    }

    public M resolve(String text) {
        if (this.cache.containsKey(text)) {
            return (M)((Match)this.cache.get(text));
        }
        char[] array = text.toCharArray();
        for (Match match : this.stack) {
            String wild = match.pattern;
            if (!this.match(array, wild.toCharArray())) continue;
            this.cache.put(text, match);
            return (M)match;
        }
        return null;
    }

    @Override
    public boolean add(M match) {
        this.stack.push(match);
        return true;
    }

    @Override
    public Iterator<M> iterator() {
        return this.stack.sequence();
    }

    @Override
    public boolean remove(M match) {
        this.cache.clear();
        return this.stack.remove(match);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.stack.clear();
    }

    private boolean match(char[] text, char[] wild) {
        return this.match(text, 0, wild, 0);
    }

    private boolean match(char[] text, int off, char[] wild, int pos) {
        while (pos < wild.length && off < text.length) {
            if (wild[pos] == '*') {
                while (wild[pos] == '*') {
                    if (++pos < wild.length) continue;
                    return true;
                }
                if (wild[pos] == '?' && ++pos >= wild.length) {
                    return true;
                }
                while (off < text.length) {
                    if (text[off] == wild[pos] || wild[pos] == '?') {
                        if (wild[pos - 1] == '?') break;
                        if (this.match(text, off, wild, pos)) {
                            return true;
                        }
                    }
                    ++off;
                }
                if (text.length == off) {
                    return false;
                }
            }
            if (text[off++] == wild[pos++] || wild[pos - 1] == '?') continue;
            return false;
        }
        if (wild.length == pos) {
            return text.length == off;
        }
        while (wild[pos] == '*') {
            if (++pos < wild.length) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stack
    extends LinkedList<M> {
        private Stack() {
        }

        @Override
        public void push(M match) {
            Resolver.this.cache.clear();
            this.addFirst(match);
        }

        public void purge(int index) {
            Resolver.this.cache.clear();
            this.remove(index);
        }

        public Iterator<M> sequence() {
            return new Sequence();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Sequence
        implements Iterator<M> {
            private int cursor;

            public Sequence() {
                this.cursor = Stack.this.size();
            }

            @Override
            public M next() {
                if (this.hasNext()) {
                    return (Match)Stack.this.get(--this.cursor);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.cursor > 0;
            }

            @Override
            public void remove() {
                Stack.this.purge(this.cursor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cache
    extends LinkedHashMap<String, M> {
        private static final int MAX_ENTRIES = 1024;
        private static final float INITIAL_CAPACITY = 0.75f;

        public Cache() {
            super(1024, 0.75f, false);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1024;
        }
    }
}

