/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Formatter;
import org.simpleframework.xml.stream.Mode;
import org.simpleframework.xml.stream.Node;
import org.simpleframework.xml.stream.NodeException;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputDocument;
import org.simpleframework.xml.stream.OutputElement;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.OutputStack;

class NodeWriter {
    private final OutputStack stack;
    private final Formatter writer;
    private final Set active;

    public NodeWriter(Writer result) {
        this(result, new Format());
    }

    public NodeWriter(Writer result, Format format) {
        this.writer = new Formatter(result, format);
        this.active = new HashSet();
        this.stack = new OutputStack(this.active);
    }

    public OutputNode writeRoot() throws Exception {
        OutputDocument root = new OutputDocument(this, this.stack);
        if (this.stack.isEmpty()) {
            this.writer.writeProlog();
        }
        return root;
    }

    public boolean isRoot(OutputNode node) {
        return this.stack.bottom() == node;
    }

    public boolean isCommitted(OutputNode node) {
        return !this.active.contains(node);
    }

    public void commit(OutputNode parent) throws Exception {
        if (this.stack.contains(parent)) {
            OutputNode top = this.stack.top();
            if (!this.isCommitted(top)) {
                this.writeAttributes(top);
            }
            while (this.stack.top() != parent) {
                this.writeEnd(this.stack.pop());
            }
            this.writeEnd(parent);
            this.stack.pop();
        }
    }

    public void remove(OutputNode node) throws Exception {
        if (this.stack.top() != node) {
            throw new NodeException("Cannot remove node");
        }
        this.writer.reset();
        this.stack.pop();
    }

    public OutputNode writeElement(OutputNode parent, String name) throws Exception {
        if (this.stack.isEmpty()) {
            return this.writeStart(parent, name);
        }
        if (this.stack.contains(parent)) {
            OutputNode top = this.stack.top();
            if (!this.isCommitted(top)) {
                this.writeAttributes(top);
            }
            while (this.stack.top() != parent) {
                this.writeEnd(this.stack.pop());
            }
            return this.writeStart(parent, name);
        }
        return null;
    }

    private OutputNode writeStart(OutputNode parent, String name) throws Exception {
        OutputElement node = new OutputElement(parent, this, name);
        if (name != null) {
            this.writer.writeStart(name);
        }
        return this.stack.push(node);
    }

    private void writeEnd(OutputNode node) throws Exception {
        Mode mode = node.getMode();
        for (OutputNode next : this.stack) {
            if (mode != Mode.INHERIT) break;
            mode = next.getMode();
        }
        this.writeEnd(node, mode);
    }

    private void writeEnd(OutputNode node, Mode mode) throws Exception {
        String value = node.getValue();
        String name = node.getName();
        if (value != null) {
            this.writer.writeText(value, mode);
        }
        this.writer.writeEnd(name);
        this.writer.flush();
    }

    private void writeAttributes(OutputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        for (String name : map) {
            Node entry = map.get(name);
            String value = entry.getValue();
            this.writer.writeAttribute(name, value);
        }
        this.active.remove(node);
    }
}

