/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.ClassType;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.transform.Transformer;

class PrimitiveFactory
extends Factory {
    private static Transformer transform = new Transformer();

    public PrimitiveFactory(Source root, Class field) {
        super(root, field);
    }

    public Type getInstance(InputNode node) throws Exception {
        Type type = this.getOverride(node);
        if (type == null) {
            return new ClassType(this.field);
        }
        return type;
    }

    public Object getInstance(String text) throws Exception {
        if (this.field == String.class) {
            return text;
        }
        if (this.field.isEnum()) {
            return Enum.valueOf(this.field, text);
        }
        return transform.read(text, this.field);
    }

    public String getText(Object source) throws Exception {
        Class<?> type = source.getClass();
        if (type.isEnum()) {
            Enum value = (Enum)source;
            return value.name();
        }
        return transform.write(source, type);
    }
}

