/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.Repeater;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class Pointer
implements Label {
    private Object value;
    private Label label;

    public Pointer(Label label, Object value) {
        this.label = label;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Converter getConverter(Source root) throws Exception {
        Converter reader = this.label.getConverter(root);
        if (reader instanceof Adapter) {
            return reader;
        }
        return new Adapter(reader, this.value);
    }

    public Contact getContact() {
        return this.label.getContact();
    }

    public Class getDependant() throws Exception {
        return this.label.getDependant();
    }

    public String getEmpty() {
        return this.label.getEmpty();
    }

    public String getEntry() throws Exception {
        return this.label.getEntry();
    }

    public String getName() throws Exception {
        return this.label.getName();
    }

    public String getOverride() {
        return this.label.getOverride();
    }

    public Class getType() {
        return this.label.getType();
    }

    public boolean isData() {
        return this.label.isData();
    }

    public boolean isInline() {
        return this.label.isInline();
    }

    public boolean isRequired() {
        return this.label.isRequired();
    }

    public String toString() {
        return ((Object)this.label).toString();
    }

    private class Adapter
    implements Repeater {
        private final Converter reader;
        private final Object value;

        public Adapter(Converter reader, Object value) {
            this.reader = reader;
            this.value = value;
        }

        public Object read(InputNode node) throws Exception {
            return this.read(node, this.value);
        }

        public Object read(InputNode node, Object value) throws Exception {
            Position line = node.getPosition();
            String name = node.getName();
            if (this.reader instanceof Repeater) {
                Repeater repeat = (Repeater)this.reader;
                return repeat.read(node, value);
            }
            throw new PersistenceException("Element '%s' declared twice at %s", name, line);
        }

        public boolean validate(InputNode node) throws Exception {
            Position line = node.getPosition();
            String name = node.getName();
            if (this.reader instanceof Repeater) {
                Repeater repeat = (Repeater)this.reader;
                return repeat.validate(node);
            }
            throw new PersistenceException("Element '%s' declared twice at %s", name, line);
        }

        public void write(OutputNode node, Object value) throws Exception {
            this.write(node, value);
        }
    }
}

