/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.load.DefaultStrategy;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Strategy;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeBuilder;
import org.simpleframework.xml.stream.OutputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persister
implements Serializer {
    private final Strategy strategy;
    private final Filter filter;
    private final Format format;

    public Persister() {
        this(new HashMap());
    }

    public Persister(Map filter) {
        this(new PlatformFilter(filter));
    }

    public Persister(Filter filter) {
        this((Strategy)new DefaultStrategy(), filter);
    }

    public Persister(Strategy strategy) {
        this(strategy, new HashMap());
    }

    public Persister(Format format) {
        this((Strategy)new DefaultStrategy(), format);
    }

    public Persister(Filter filter, Format format) {
        this((Strategy)new DefaultStrategy(), filter, format);
    }

    public Persister(Strategy strategy, Format format) {
        this(strategy, new HashMap(), format);
    }

    public Persister(Strategy strategy, Map data) {
        this(strategy, new PlatformFilter(data));
    }

    public Persister(Strategy strategy, Filter filter) {
        this(strategy, filter, new Format());
    }

    public Persister(Strategy strategy, Map data, Format format) {
        this(strategy, new PlatformFilter(data), format);
    }

    public Persister(Strategy strategy, Filter filter, Format format) {
        this.strategy = strategy;
        this.filter = filter;
        this.format = format;
    }

    @Override
    public <T> T read(Class<? extends T> type, String source) throws Exception {
        return (T)this.read((T)type, (Reader)new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T read(Class<? extends T> type, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            Class<? extends T> clazz = this.read((T)type, (InputStream)file);
            return (T)clazz;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source) throws Exception {
        return (T)this.read((T)type, source, "utf-8");
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source, String charset) throws Exception {
        return (T)this.read((T)type, (Reader)new InputStreamReader(source, charset));
    }

    @Override
    public <T> T read(Class<? extends T> type, Reader source) throws Exception {
        return (T)this.read((T)type, NodeBuilder.read(source));
    }

    public <T> T read(Class<? extends T> type, InputNode source) throws Exception {
        return (T)this.read((T)type, source, this.filter);
    }

    private <T> T read(Class<? extends T> type, InputNode node, Filter filter) throws Exception {
        return (T)this.read((T)type, node, new Source(this.strategy, filter));
    }

    private <T> T read(Class<? extends T> type, InputNode node, Source source) throws Exception {
        return (T)new Traverser(source).read(node, type);
    }

    @Override
    public <T> T read(T value, String source) throws Exception {
        return this.read(value, (Reader)new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T read(T value, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            T t = this.read(value, (InputStream)file);
            return t;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public <T> T read(T value, InputStream source) throws Exception {
        return this.read(value, source, "utf-8");
    }

    @Override
    public <T> T read(T value, InputStream source, String charset) throws Exception {
        return this.read(value, (Reader)new InputStreamReader(source, charset));
    }

    @Override
    public <T> T read(T value, Reader source) throws Exception {
        return this.read(value, NodeBuilder.read(source));
    }

    public <T> T read(T value, InputNode source) throws Exception {
        return this.read(value, source, this.filter);
    }

    private <T> T read(T value, InputNode node, Filter filter) throws Exception {
        return this.read(value, node, new Source(this.strategy, filter));
    }

    private <T> T read(T value, InputNode node, Source source) throws Exception {
        return (T)new Traverser(source).read(node, value);
    }

    @Override
    public boolean validate(Class type, String source) throws Exception {
        return this.validate(type, new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(Class type, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            boolean bl = this.validate(type, file);
            return bl;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public boolean validate(Class type, InputStream source) throws Exception {
        return this.validate(type, source, "utf-8");
    }

    @Override
    public boolean validate(Class type, InputStream source, String charset) throws Exception {
        return this.validate(type, new InputStreamReader(source, charset));
    }

    @Override
    public boolean validate(Class type, Reader source) throws Exception {
        return this.validate(type, NodeBuilder.read(source));
    }

    public boolean validate(Class type, InputNode source) throws Exception {
        return this.validate(type, source, this.filter);
    }

    private boolean validate(Class type, InputNode node, Filter filter) throws Exception {
        return this.validate(type, node, new Source(this.strategy, filter));
    }

    private boolean validate(Class type, InputNode node, Source source) throws Exception {
        return new Traverser(source).validate(node, type);
    }

    public void write(Object source, OutputNode root) throws Exception {
        this.write(source, root, this.filter);
    }

    private void write(Object source, OutputNode root, Filter filter) throws Exception {
        this.write(source, root, new Source(this.strategy, filter));
    }

    private void write(Object source, OutputNode node, Source root) throws Exception {
        new Traverser(root).write(node, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object source, File out) throws Exception {
        FileOutputStream file = new FileOutputStream(out);
        try {
            this.write(source, file);
        }
        finally {
            ((OutputStream)file).close();
        }
    }

    @Override
    public void write(Object source, OutputStream out) throws Exception {
        this.write(source, out, "utf-8");
    }

    @Override
    public void write(Object source, OutputStream out, String charset) throws Exception {
        this.write(source, new OutputStreamWriter(out, charset));
    }

    @Override
    public void write(Object source, Writer out) throws Exception {
        this.write(source, NodeBuilder.write(out, this.format));
    }
}

