/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.Map;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.MapFactory;
import org.simpleframework.xml.load.Repeater;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class CompositeInlineMap
implements Repeater {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Entry entry;

    public CompositeInlineMap(Source root, Entry entry, Class type) throws Exception {
        this.factory = new MapFactory(root, type);
        this.value = entry.getValue(root);
        this.key = entry.getKey(root);
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Object value = this.factory.getInstance();
        Map table = (Map)value;
        if (table != null) {
            return this.read(node, table);
        }
        return null;
    }

    public Object read(InputNode node, Object value) throws Exception {
        Map map = (Map)value;
        if (map != null) {
            return this.read(node, map);
        }
        return this.read(node);
    }

    private Object read(InputNode node, Map map) throws Exception {
        InputNode from = node.getParent();
        String name = node.getName();
        while (node != null) {
            Object key = this.readKey(node);
            Object value = this.readValue(node);
            if (key != null) {
                map.put(key, value);
            }
            node = from.getNext(name);
        }
        return map;
    }

    private Object readKey(InputNode node) throws Exception {
        return this.key.read(node);
    }

    private Object readValue(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Could not find element '%s' at %s", name, line);
        }
        return this.value.read(node);
    }

    public boolean validate(InputNode node) throws Exception {
        InputNode from = node.getParent();
        String name = node.getName();
        while (node != null) {
            if (!this.validateKey(node)) {
                return false;
            }
            if (!this.validateValue(node)) {
                return false;
            }
            node = from.getNext(name);
        }
        return true;
    }

    private boolean validateKey(InputNode node) throws Exception {
        return this.key.validate(node);
    }

    private boolean validateValue(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Could not find element '%s' at %s", name, line);
        }
        return this.value.validate(node);
    }

    public void write(OutputNode node, Object source) throws Exception {
        OutputNode parent = node.getParent();
        Map table = (Map)source;
        if (!node.isCommitted()) {
            node.remove();
        }
        this.write(parent, table);
    }

    public void write(OutputNode node, Map map) throws Exception {
        for (Object key : map.keySet()) {
            String name = this.entry.getEntry();
            OutputNode next = node.getChild(name);
            Object value = map.get(key);
            if (value == null) continue;
            this.writeKey(next, key);
            this.writeValue(next, value);
        }
    }

    private void writeKey(OutputNode node, Object item) throws Exception {
        this.key.write(node, item);
    }

    private void writeValue(OutputNode node, Object item) throws Exception {
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getChild(name);
        }
        this.value.write(node, item);
    }
}

