/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.graph;

import java.util.HashMap;
import org.simpleframework.xml.graph.Allocate;
import org.simpleframework.xml.graph.ArrayInstance;
import org.simpleframework.xml.graph.Contract;
import org.simpleframework.xml.graph.CycleException;
import org.simpleframework.xml.graph.Instance;
import org.simpleframework.xml.graph.Reference;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.Node;
import org.simpleframework.xml.stream.NodeMap;

class ReadGraph
extends HashMap {
    private ClassLoader loader;
    private String length;
    private String label;
    private String mark;
    private String refer;

    public ReadGraph(Contract contract, ClassLoader loader) {
        this.refer = contract.getReference();
        this.mark = contract.getIdentity();
        this.length = contract.getLength();
        this.label = contract.getLabel();
        this.loader = loader;
    }

    public Type getElement(Class field, NodeMap node) throws Exception {
        Node entry = node.remove(this.label);
        Class<?> type = field;
        if (field.isArray()) {
            type = field.getComponentType();
        }
        if (entry != null) {
            String name = entry.getValue();
            type = this.loader.loadClass(name);
        }
        return this.getInstance(field, type, node);
    }

    private Type getInstance(Class field, Class real, NodeMap node) throws Exception {
        Node entry = node.remove(this.mark);
        if (entry == null) {
            return this.getReference(field, real, node);
        }
        String key = entry.getValue();
        if (this.containsKey(key)) {
            throw new CycleException("Element '%s' already exists", key);
        }
        return this.getType(field, real, node, key);
    }

    private Type getReference(Class field, Class real, NodeMap node) throws Exception {
        Node entry = node.remove(this.refer);
        if (entry == null) {
            return this.getType(field, real, node);
        }
        String key = entry.getValue();
        Object value = this.get(key);
        if (value == null) {
            throw new CycleException("Invalid reference '%s' found", key);
        }
        return new Reference(value, real);
    }

    private Type getType(Class field, Class real, NodeMap node) throws Exception {
        if (field.isArray()) {
            return this.getArray(field, real, node);
        }
        return new Instance(real);
    }

    private Type getType(Class field, Class real, NodeMap node, String key) throws Exception {
        Type type = this.getType(field, real, node);
        if (key != null) {
            return new Allocate(type, this, key);
        }
        return type;
    }

    private Type getArray(Class field, Class real, NodeMap node) throws Exception {
        Node entry = node.remove(this.length);
        int size = 0;
        if (entry != null) {
            String value = entry.getValue();
            size = Integer.parseInt(value);
        }
        return new ArrayInstance(real, size);
    }
}

