/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.graph;

import java.util.Map;
import org.simpleframework.xml.graph.Contract;
import org.simpleframework.xml.graph.ReadGraph;
import org.simpleframework.xml.graph.ReadState;
import org.simpleframework.xml.graph.WriteGraph;
import org.simpleframework.xml.graph.WriteState;
import org.simpleframework.xml.load.Strategy;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.NodeMap;

public class CycleStrategy
implements Strategy {
    private static final String REFER = "reference";
    private static final String MARK = "id";
    private static final String LENGTH = "length";
    private static final String LABEL = "class";
    private WriteState write;
    private ReadState read;
    private Contract contract;

    public CycleStrategy() {
        this(MARK, REFER);
    }

    public CycleStrategy(String mark, String refer) {
        this(mark, refer, LABEL);
    }

    public CycleStrategy(String mark, String refer, String label) {
        this(mark, refer, label, LENGTH);
    }

    public CycleStrategy(String mark, String refer, String label, String length) {
        this.contract = new Contract(mark, refer, label, length);
        this.write = new WriteState(this.contract);
        this.read = new ReadState(this.contract);
    }

    public Type getRoot(Class field, NodeMap node, Map map) throws Exception {
        return this.getElement(field, node, map);
    }

    public Type getElement(Class field, NodeMap node, Map map) throws Exception {
        ReadGraph graph = this.read.find(map);
        if (graph != null) {
            return graph.getElement(field, node);
        }
        return null;
    }

    public boolean setRoot(Class field, Object value, NodeMap node, Map map) {
        return this.setElement(field, value, node, map);
    }

    public boolean setElement(Class field, Object value, NodeMap node, Map map) {
        WriteGraph graph = this.write.find(map);
        if (graph != null) {
            return graph.setElement(field, value, node);
        }
        return false;
    }
}

