/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform.lang;

import java.lang.reflect.Array;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.lang.StringArrayTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTransform {
    private final StringArrayTransform split = new StringArrayTransform();
    private final Class entry;

    public ArrayTransform(Class entry) {
        this.entry = entry;
    }

    public <T> T read(String value, Transform single) throws Exception {
        String[] list = this.split.read(value);
        int length = list.length;
        return (T)this.read(list, single, length);
    }

    private Object read(String[] list, Transform single, int length) throws Exception {
        Object array = Array.newInstance(this.entry, length);
        for (int i = 0; i < length; ++i) {
            Object item = single.read(list[i]);
            if (item == null) continue;
            Array.set(array, i, item);
        }
        return array;
    }

    public String write(Object[] value, Transform single) throws Exception {
        String[] list = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            Object entry = Array.get(value, i);
            if (entry == null) continue;
            list[i] = single.write(entry);
        }
        return this.split.write(list);
    }
}

