/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.load.ContactList;
import org.simpleframework.xml.load.MethodContact;
import org.simpleframework.xml.load.MethodException;
import org.simpleframework.xml.load.MethodPart;
import org.simpleframework.xml.load.MethodPartFactory;
import org.simpleframework.xml.load.MethodType;

class MethodScanner
extends ContactList {
    private PartMap write = new PartMap();
    private PartMap read = new PartMap();
    private Class type;

    public MethodScanner(Class type) throws Exception {
        this.type = type;
        this.scan(type);
    }

    private void scan(Class type) throws Exception {
        Class real = type;
        while (type != null) {
            this.scan(real, type);
            type = type.getSuperclass();
        }
        this.build();
        this.validate();
    }

    private void scan(Class real, Class type) throws Exception {
        Method[] method = type.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            this.scan(method[i]);
        }
    }

    private void scan(Method method) throws Exception {
        Annotation[] list = method.getDeclaredAnnotations();
        for (int i = 0; i < list.length; ++i) {
            this.scan(method, list[i]);
        }
    }

    private void scan(Method method, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(method, label);
        }
        if (label instanceof ElementList) {
            this.process(method, label);
        }
        if (label instanceof ElementArray) {
            this.process(method, label);
        }
        if (label instanceof Element) {
            this.process(method, label);
        }
        if (label instanceof Text) {
            this.process(method, label);
        }
    }

    private void process(Method method, Annotation label) throws Exception {
        MethodPart part = MethodPartFactory.getInstance(method, label);
        MethodType type = part.getMethodType();
        if (type == MethodType.GET) {
            this.process(part, this.read);
        }
        if (type == MethodType.IS) {
            this.process(part, this.read);
        }
        if (type == MethodType.SET) {
            this.process(part, this.write);
        }
    }

    private void process(MethodPart method, PartMap map) {
        String name = method.getName();
        if (!map.containsKey(name)) {
            map.put(name, method);
        }
    }

    private void build() throws Exception {
        for (String name : this.read) {
            MethodPart part = (MethodPart)this.read.get(name);
            if (part == null) continue;
            this.build(part, name);
        }
    }

    private void build(MethodPart read, String name) throws Exception {
        MethodPart match = this.write.take(name);
        Method method = read.getMethod();
        if (match == null) {
            throw new MethodException("No matching set method for %s in %s", method, this.type);
        }
        this.build(read, match);
    }

    private void build(MethodPart read, MethodPart write) throws Exception {
        Annotation label = read.getAnnotation();
        String name = read.getName();
        if (!((Object)write.getAnnotation()).equals(label)) {
            throw new MethodException("Annotations do not match for '%s' in %s", name, this.type);
        }
        Class type = read.getType();
        if (type != write.getType()) {
            throw new MethodException("Method types do not match for %s in %s", name, type);
        }
        this.add(new MethodContact(read, write));
    }

    private void validate() throws Exception {
        for (String name : this.write) {
            MethodPart part = (MethodPart)this.write.get(name);
            if (part == null) continue;
            this.validate(part, name);
        }
    }

    private void validate(MethodPart write, String name) throws Exception {
        MethodPart match = this.read.take(name);
        Method method = write.getMethod();
        if (match == null) {
            throw new MethodException("No matching get method for %s in %s", method, this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PartMap
    extends HashMap<String, MethodPart>
    implements Iterable<String> {
        private PartMap() {
        }

        @Override
        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        public MethodPart take(String name) {
            return (MethodPart)this.remove(name);
        }
    }
}

