/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.reflect.Modifier;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

abstract class Factory {
    protected Source source;
    protected Class field;

    protected Factory(Source source, Class field) {
        this.source = source;
        this.field = field;
    }

    public Type getOverride(InputNode node) throws Exception {
        Class real;
        Type type = this.getConversion(node);
        if (type != null && !Factory.isCompatible(this.field, real = type.getType())) {
            throw new InstantiationException("Type %s is not compatible with %s", real, this.field);
        }
        return type;
    }

    public boolean setOverride(Class field, Object value, OutputNode node) throws Exception {
        if (!field.isPrimitive()) {
            return this.source.setOverride(field, value, node);
        }
        return false;
    }

    public Type getConversion(InputNode node) throws Exception {
        return this.source.getOverride(this.field, node);
    }

    public static boolean isCompatible(Class field, Class type) {
        if (field.isArray()) {
            field = field.getComponentType();
        }
        return field.isAssignableFrom(type);
    }

    public static boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        return !Modifier.isInterface(modifiers);
    }

    public static boolean isPrimitive(Class type) {
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        if (type == Double.class) {
            return true;
        }
        if (type == Byte.class) {
            return true;
        }
        if (type == Short.class) {
            return true;
        }
        if (type == Character.class) {
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        return type.isEnum();
    }
}

