/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.Collection;
import org.simpleframework.xml.load.CollectionFactory;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.RootException;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeInlineList
implements Converter {
    private final CollectionFactory factory;
    private final Traverser root;
    private final Class entry;

    public CompositeInlineList(Source root, Class type, Class entry) {
        this.factory = new CollectionFactory(root, type);
        this.root = new Traverser(root);
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Object value = this.factory.getInstance();
        Collection list = (Collection)value;
        if (list != null) {
            return this.read(node, list);
        }
        return null;
    }

    private Object read(InputNode node, Collection list) throws Exception {
        InputNode from = node.getParent();
        String name = node.getName();
        while (node != null) {
            Object item = this.read(node, this.entry);
            if (item != null) {
                list.add(item);
            }
            node = from.getNext(name);
        }
        return list;
    }

    private Object read(InputNode node, Class expect) throws Exception {
        Object item = this.root.read(node, expect);
        Class<?> type = item.getClass();
        if (!this.isCompatible(type, this.entry)) {
            throw new RootException("Root name for %s must match %s", type, expect);
        }
        return item;
    }

    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        OutputNode parent = node.getParent();
        if (!node.isCommitted()) {
            node.remove();
        }
        this.write(parent, list);
    }

    public void write(OutputNode node, Collection list) throws Exception {
        for (Object item : list) {
            if (item == null) continue;
            Class<?> type = item.getClass();
            if (!this.isCompatible(type, this.entry)) {
                throw new RootException("Root name for %s must match %s", type, this.entry);
            }
            this.root.write(node, item, this.entry);
        }
    }

    private boolean isCompatible(Class type, Class expect) throws Exception {
        String require = this.root.getName(expect);
        String real = this.root.getName(type);
        if (!this.entry.isAssignableFrom(type)) {
            throw new PersistenceException("Entry %s does not match %s", type, this.entry);
        }
        return require == real;
    }
}

