/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.SSLContext;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketAnalyzer;
import org.simpleframework.transport.connect.SocketListener;
import org.simpleframework.transport.trace.TraceAnalyzer;

class SocketListenerManager
implements Closeable {
    private final Set<SocketListener> listeners = new CopyOnWriteArraySet<SocketListener>();
    private final SocketProcessor processor;
    private final TraceAnalyzer analyzer;

    public SocketListenerManager(SocketProcessor processor, TraceAnalyzer analyzer) {
        this.analyzer = new SocketAnalyzer(analyzer);
        this.processor = processor;
    }

    public SocketAddress listen(SocketAddress address) throws IOException {
        return this.listen(address, null);
    }

    public SocketAddress listen(SocketAddress address, SSLContext context) throws IOException {
        SocketListener listener = new SocketListener(address, this.processor, this.analyzer, context);
        if (this.processor != null) {
            listener.process();
            this.listeners.add(listener);
        }
        return listener.getAddress();
    }

    public void close() throws IOException {
        for (SocketListener listener : this.listeners) {
            listener.close();
        }
        if (this.analyzer != null) {
            this.analyzer.stop();
        }
        this.listeners.clear();
    }
}

