/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.ConnectionException;
import org.simpleframework.transport.connect.SocketAcceptor;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.reactor.SynchronousReactor;
import org.simpleframework.transport.trace.TraceAnalyzer;

class SocketListener
implements Closeable {
    private final SocketAcceptor acceptor;
    private final Reactor reactor;

    public SocketListener(SocketAddress address, SocketProcessor processor, TraceAnalyzer analyzer) throws IOException {
        this(address, processor, analyzer, null);
    }

    public SocketListener(SocketAddress address, SocketProcessor processor, TraceAnalyzer analyzer, SSLContext context) throws IOException {
        this.acceptor = new SocketAcceptor(address, processor, analyzer, context);
        this.reactor = new SynchronousReactor();
    }

    public SocketAddress getAddress() {
        return this.acceptor.getAddress();
    }

    public void process() throws IOException {
        try {
            this.acceptor.bind();
            this.reactor.process(this.acceptor, 16);
        }
        catch (Exception cause) {
            throw new ConnectionException("Listen error", cause);
        }
    }

    public void close() throws IOException {
        try {
            this.acceptor.close();
            this.reactor.stop();
        }
        catch (Exception cause) {
            throw new ConnectionException("Close error", cause);
        }
    }
}

