/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.FlushScheduler;
import org.simpleframework.transport.FlushSignaller;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketBuffer;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Reactor;

class SocketFlusher {
    private FlushSignaller signaller;
    private FlushScheduler scheduler;
    private SocketBuffer buffer;
    private boolean closed;

    public SocketFlusher(SocketBuffer buffer, Socket socket, Reactor reactor) throws IOException {
        this.signaller = new FlushSignaller(this, socket);
        this.scheduler = new FlushScheduler(socket, reactor, this.signaller, this);
        this.buffer = buffer;
    }

    public synchronized void flush() throws IOException {
        boolean block;
        if (this.closed) {
            throw new TransportException("Flusher is closed");
        }
        boolean bl = block = !this.buffer.ready();
        if (!this.closed) {
            this.scheduler.schedule(block);
        }
    }

    public synchronized void execute() throws IOException {
        boolean ready = this.buffer.flush();
        if (!ready) {
            boolean block;
            boolean bl = block = !this.buffer.ready();
            if (!block && !this.closed) {
                this.scheduler.release();
            }
            this.scheduler.repeat();
        } else {
            this.scheduler.ready();
        }
    }

    public synchronized void abort() throws IOException {
        this.scheduler.close();
        this.buffer.close();
    }

    public synchronized void close() throws IOException {
        boolean ready = this.buffer.flush();
        if (!this.closed) {
            this.closed = true;
        }
        if (!ready) {
            this.scheduler.schedule(true);
        }
    }
}

