/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketBuffer;
import org.simpleframework.transport.SocketFlusher;
import org.simpleframework.transport.reactor.Reactor;

class SocketBufferWriter {
    private final SocketFlusher flusher;
    private final SocketBuffer writer;

    public SocketBufferWriter(Socket socket, Reactor reactor, int buffer, int threshold) throws IOException {
        this.writer = new SocketBuffer(socket, buffer, threshold);
        this.flusher = new SocketFlusher(this.writer, socket, reactor);
    }

    public void write(ByteBuffer buffer) throws IOException {
        boolean done = this.writer.write(buffer);
        if (!done) {
            this.flusher.flush();
        }
    }

    public void flush() throws IOException {
        boolean done = this.writer.flush();
        if (!done) {
            this.flusher.flush();
        }
    }

    public void close() throws IOException {
        this.flusher.close();
        this.writer.close();
    }
}

