/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Handshake;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketTransport;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportDispatcher;
import org.simpleframework.transport.TransportProcessor;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;

class OperationFactory {
    private final TransportProcessor processor;
    private final Reactor reactor;
    private final int threshold;
    private final int buffer;
    private final boolean client;

    public OperationFactory(TransportProcessor processor, Reactor reactor, int buffer) {
        this(processor, reactor, buffer, 20480);
    }

    public OperationFactory(TransportProcessor processor, Reactor reactor, int buffer, int threshold) {
        this(processor, reactor, buffer, threshold, false);
    }

    public OperationFactory(TransportProcessor processor, Reactor reactor, int buffer, int threshold, boolean client) {
        this.processor = processor;
        this.threshold = threshold;
        this.reactor = reactor;
        this.buffer = buffer;
        this.client = client;
    }

    public Operation getInstance(Socket socket) throws IOException {
        return this.getInstance(socket, socket.getEngine());
    }

    private Operation getInstance(Socket socket, SSLEngine engine) throws IOException {
        SocketTransport transport = new SocketTransport(socket, this.reactor, this.buffer, this.threshold);
        if (engine != null) {
            return new Handshake(this.processor, (Transport)transport, this.reactor, this.client);
        }
        return new TransportDispatcher(this.processor, transport);
    }
}

