/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.common.lease.Cleaner;
import org.simpleframework.common.lease.Contract;
import org.simpleframework.common.lease.ContractQueue;
import org.simpleframework.common.lease.LeaseException;
import org.simpleframework.common.thread.Daemon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeaseCleaner<T>
extends Daemon {
    private final ContractQueue<T> queue = new ContractQueue();
    private final Cleaner<T> cleaner;

    public LeaseCleaner(Cleaner<T> cleaner) {
        this.cleaner = cleaner;
        this.start();
    }

    public boolean revoke(Contract<T> contract) throws LeaseException {
        if (!this.isActive()) {
            throw new LeaseException("Lease can not be revoked");
        }
        return this.queue.remove(contract);
    }

    public boolean issue(Contract<T> contract) throws LeaseException {
        if (!this.isActive()) {
            throw new LeaseException("Lease can not be issued");
        }
        return this.queue.offer(contract);
    }

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                this.clean();
            }
            catch (Throwable e) {}
        }
        this.purge();
    }

    private void clean() throws Exception {
        Contract next = (Contract)this.queue.take();
        Object key = next.getKey();
        if (key != null) {
            this.cleaner.clean(key);
        }
    }

    private void purge() {
        for (Contract contract : this.queue) {
            Object key = contract.getKey();
            try {
                contract.setDelay(0L, TimeUnit.NANOSECONDS);
                this.cleaner.clean(key);
            }
            catch (Throwable e) {}
        }
    }

    public void close() {
        this.stop();
        this.interrupt();
    }
}

