/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.common.lease.Contract;
import org.simpleframework.common.lease.ContractController;
import org.simpleframework.common.lease.Lease;
import org.simpleframework.common.lease.LeaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContractLease<T>
implements Lease<T> {
    private final ContractController<T> handler;
    private final Contract<T> contract;

    public ContractLease(ContractController<T> handler, Contract<T> contract) {
        this.handler = handler;
        this.contract = contract;
    }

    @Override
    public long getExpiry(TimeUnit unit) throws LeaseException {
        return this.contract.getDelay(unit);
    }

    @Override
    public void renew(long duration, TimeUnit unit) throws LeaseException {
        if (duration >= 0L) {
            this.contract.setDelay(duration, unit);
        }
        this.handler.renew(this.contract);
    }

    @Override
    public void cancel() throws LeaseException {
        this.handler.cancel(this.contract);
    }

    @Override
    public T getKey() {
        return this.contract.getKey();
    }
}

