/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.map.MapperBuildingException;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.SetterHelper;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ClassVisitor;
import org.sfm.reflect.meta.ConstructorPropertyMeta;
import org.sfm.reflect.meta.FieldAndMethodCallBack;
import org.sfm.reflect.meta.FieldPropertyMeta;
import org.sfm.reflect.meta.MethodPropertyMeta;
import org.sfm.reflect.meta.ObjectPropertyFinder;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.ErrorHelper;

public final class ObjectClassMeta<T>
implements ClassMeta<T> {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<PropertyMeta<T, ?>> properties;
    private final List<ConstructorPropertyMeta<T, ?>> constructorProperties;
    private final List<InstantiatorDefinition> instantiatorDefinitions;
    private final ReflectionService reflectService;
    private final Type target;
    private final Map<String, String> fieldAliases;

    public ObjectClassMeta(Type target, ReflectionService reflectService) throws MapperBuildingException {
        this.target = target;
        this.reflectService = reflectService;
        try {
            this.instantiatorDefinitions = reflectService.extractConstructors(target);
            this.constructorProperties = Collections.unmodifiableList(this.listProperties(this.instantiatorDefinitions));
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            throw new IllegalStateException();
        }
        this.fieldAliases = Collections.unmodifiableMap(this.aliases(reflectService, TypeHelper.toClass(target)));
        this.properties = Collections.unmodifiableList(this.listProperties(reflectService, target));
    }

    public ObjectClassMeta(Type target, List<InstantiatorDefinition> instantiatorDefinitions, List<ConstructorPropertyMeta<T, ?>> constructorProperties, List<PropertyMeta<T, ?>> properties, ReflectionService reflectService) {
        this.target = target;
        this.properties = properties;
        this.constructorProperties = constructorProperties;
        this.instantiatorDefinitions = instantiatorDefinitions;
        this.fieldAliases = Collections.unmodifiableMap(this.aliases(reflectService, TypeHelper.toClass(target)));
        this.reflectService = reflectService;
    }

    private Map<String, String> aliases(final ReflectionService reflectService, Class<T> target) {
        final HashMap<String, String> map = new HashMap<String, String>();
        ClassVisitor.visit(target, new FieldAndMethodCallBack(){

            @Override
            public void method(Method method) {
                String alias = reflectService.getColumnName(method);
                if (alias != null) {
                    map.put(SetterHelper.getPropertyNameFromMethodName(method.getName()), alias);
                }
            }

            @Override
            public void field(Field field) {
                String alias = reflectService.getColumnName(field);
                if (alias != null) {
                    map.put(field.getName(), alias);
                }
            }
        });
        return map;
    }

    private List<ConstructorPropertyMeta<T, ?>> listProperties(List<InstantiatorDefinition> instantiatorDefinitions) {
        if (instantiatorDefinitions == null) {
            return null;
        }
        ArrayList constructorProperties = new ArrayList();
        for (InstantiatorDefinition cd : instantiatorDefinitions) {
            for (Parameter param : cd.getParameters()) {
                String paramName = param.getName();
                constructorProperties.add(this.constructorMeta(param, paramName));
            }
        }
        return constructorProperties;
    }

    private <P> ConstructorPropertyMeta<T, P> constructorMeta(Parameter param, String paramName) {
        Class tClass = TypeHelper.toClass(this.target);
        return new ConstructorPropertyMeta(paramName, this.reflectService, param, tClass);
    }

    private List<PropertyMeta<T, ?>> listProperties(final ReflectionService reflectService, Type targetType) {
        Class target = TypeHelper.toClass(targetType);
        final ArrayList properties = new ArrayList();
        final Map<TypeVariable<?>, Type> typeVariableTypeMap = TypeHelper.getTypesMap(targetType, target);
        ClassVisitor.visit(target, new FieldAndMethodCallBack(){

            @Override
            public void method(Method method) {
                String name = method.getName();
                if (SetterHelper.methodModifiersMatches(method.getModifiers()) && SetterHelper.isSetter(name)) {
                    Type mappedType;
                    String propertyName = SetterHelper.getPropertyNameFromMethodName(name);
                    int indexOfProperty = this.findProperty(properties, propertyName);
                    Type resolvedType = method.getGenericParameterTypes()[0];
                    if (resolvedType instanceof TypeVariable && (mappedType = (Type)typeVariableTypeMap.get(resolvedType)) != null) {
                        resolvedType = mappedType;
                    }
                    MethodPropertyMeta propertyMeta = new MethodPropertyMeta(propertyName, reflectService, method, resolvedType);
                    if (indexOfProperty == -1) {
                        properties.add(propertyMeta);
                    } else {
                        properties.set(indexOfProperty, propertyMeta);
                    }
                }
            }

            @Override
            public void field(Field field) {
                int indexOfProperty;
                String name = field.getName();
                if (SetterHelper.fieldModifiersMatches(field.getModifiers()) && (indexOfProperty = this.findProperty(properties, name)) == -1) {
                    Type mappedType;
                    Type resolvedType = field.getGenericType();
                    if (resolvedType instanceof TypeVariable && (mappedType = (Type)typeVariableTypeMap.get(resolvedType)) != null) {
                        resolvedType = mappedType;
                    }
                    properties.add(new FieldPropertyMeta(field.getName(), reflectService, field, resolvedType));
                }
            }

            private int findProperty(List<PropertyMeta<T, ?>> properties2, String name) {
                for (int i = 0; i < properties2.size(); ++i) {
                    if (!properties2.get(i).getName().equals(name)) continue;
                    return i;
                }
                return -1;
            }
        });
        return properties;
    }

    protected String getAlias(String propertyName) {
        String columnName = this.fieldAliases.get(propertyName);
        if (columnName == null) {
            columnName = propertyName;
        }
        return columnName;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return this.instantiatorDefinitions;
    }

    List<PropertyMeta<T, ?>> getProperties() {
        return this.properties;
    }

    List<ConstructorPropertyMeta<T, ?>> getConstructorProperties() {
        return this.constructorProperties;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new ObjectPropertyFinder(this);
    }

    @Override
    public Type getType() {
        return this.target;
    }

    @Override
    public String[] generateHeaders() {
        ArrayList<String> strings = new ArrayList<String>();
        for (PropertyMeta propertyMeta : this.constructorProperties) {
            this.extractProperties(strings, propertyMeta);
        }
        for (PropertyMeta propertyMeta : this.properties) {
            this.extractProperties(strings, propertyMeta);
        }
        return strings.toArray(EMPTY_STRING_ARRAY);
    }

    private void extractProperties(List<String> properties, PropertyMeta<T, ?> cpm) {
        String prefix = cpm.getName();
        ClassMeta<?> classMeta = cpm.getPropertyClassMeta();
        if (classMeta != null) {
            for (String prop : classMeta.generateHeaders()) {
                String name;
                String string = name = prop.length() == 0 ? prefix : prefix + "_" + prop;
                if (properties.contains(name)) continue;
                properties.add(this.formatName(name));
            }
        } else if (!properties.contains(prefix)) {
            properties.add(this.formatName(prefix));
        }
    }

    private String formatName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean lastWasUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastWasUpperCase) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            lastWasUpperCase = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

