/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class FactoryClassLoader
extends ClassLoader {
    private final Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
    private final List<ClassLoader> delegateClassLoader = new ArrayList<ClassLoader>();
    private final Lock lock = new ReentrantLock();

    public FactoryClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> registerClass(String name, byte[] bytes, ClassLoader classLoader) {
        this.lock.lock();
        try {
            ClassInfo info = this.classes.get(name);
            if (info != null) {
                if (!Arrays.equals(info.bytes, bytes)) {
                    throw new LinkageError("Class " + name + " is defined with different bytecodes");
                }
            } else {
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                info = new ClassInfo(bytes, clazz);
                this.classes.put(name, info);
                if (classLoader != null && !this.isAlreadyAccessible(classLoader)) {
                    this.delegateClassLoader.add(classLoader);
                }
            }
            Class clazz = info.clazz;
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isAlreadyAccessible(ClassLoader classLoader) {
        if (this.isAccessibleFrom(classLoader, this.getParent())) {
            return true;
        }
        for (ClassLoader cl : this.delegateClassLoader) {
            if (!this.isAccessibleFrom(classLoader, cl)) continue;
            return true;
        }
        return false;
    }

    private boolean isAccessibleFrom(ClassLoader classLoader, ClassLoader from) {
        for (ClassLoader parent = from; parent != null; parent = parent.getParent()) {
            if (!parent.equals(classLoader)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            for (ClassLoader cl : this.delegateClassLoader) {
                try {
                    return cl.loadClass(name);
                }
                catch (ClassNotFoundException e2) {
                }
            }
            throw e;
        }
    }

    private class ClassInfo {
        private final byte[] bytes;
        private final Class<?> clazz;

        private ClassInfo(byte[] bytes, Class<?> clazz) {
            this.bytes = bytes;
            this.clazz = clazz;
        }
    }
}

