/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.time.Instant;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaYearFromObjectGetter<S>
implements Getter<S, Year> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaYearFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public Year get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            ZonedDateTime dateTime = Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone);
            return Year.of(dateTime.getYear());
        }
        if (o instanceof Integer || o instanceof Long) {
            return Year.of(((Number)o).intValue());
        }
        if (o instanceof TemporalAccessor) {
            return Year.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to Year");
    }

    public String toString() {
        return "JavaYearFromObjectGetter{getter=" + this.getter + '}';
    }
}

