/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.fieldmapper;

import java.lang.reflect.Type;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.GetterFactory;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.impl.FieldMapperColumnDefinition;
import org.sfm.map.impl.PropertyMapping;
import org.sfm.map.impl.TypeAffinity;
import org.sfm.map.impl.fieldmapper.BooleanFieldMapper;
import org.sfm.map.impl.fieldmapper.ByteFieldMapper;
import org.sfm.map.impl.fieldmapper.CharacterFieldMapper;
import org.sfm.map.impl.fieldmapper.DoubleFieldMapper;
import org.sfm.map.impl.fieldmapper.FieldMapperImpl;
import org.sfm.map.impl.fieldmapper.FloatFieldMapper;
import org.sfm.map.impl.fieldmapper.IntFieldMapper;
import org.sfm.map.impl.fieldmapper.LongFieldMapper;
import org.sfm.map.impl.fieldmapper.ShortFieldMapper;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorOnGetter;
import org.sfm.reflect.ObjectGetterFactory;
import org.sfm.reflect.ObjectSetterFactory;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyMeta;

public final class FieldMapperFactory<S, K extends FieldKey<K>> {
    private final GetterFactory<? super S, K> getterFactory;

    public FieldMapperFactory(GetterFactory<? super S, K> getterFactory) {
        this.getterFactory = getterFactory;
    }

    private <T, P> FieldMapper<S, T> primitiveIndexedFieldMapper(Class<P> type, Setter<T, ? super P> setter, Getter<? super S, ? extends P> getter) {
        if (type.equals(Boolean.TYPE)) {
            return new BooleanFieldMapper<S, T>(ObjectGetterFactory.toBooleanGetter(getter), ObjectSetterFactory.toBooleanSetter(setter));
        }
        if (type.equals(Integer.TYPE)) {
            return new IntFieldMapper<S, T>(ObjectGetterFactory.toIntGetter(getter), ObjectSetterFactory.toIntSetter(setter));
        }
        if (type.equals(Long.TYPE)) {
            return new LongFieldMapper<S, T>(ObjectGetterFactory.toLongGetter(getter), ObjectSetterFactory.toLongSetter(setter));
        }
        if (type.equals(Float.TYPE)) {
            return new FloatFieldMapper<S, T>(ObjectGetterFactory.toFloatGetter(getter), ObjectSetterFactory.toFloatSetter(setter));
        }
        if (type.equals(Double.TYPE)) {
            return new DoubleFieldMapper<S, T>(ObjectGetterFactory.toDoubleGetter(getter), ObjectSetterFactory.toDoubleSetter(setter));
        }
        if (type.equals(Byte.TYPE)) {
            return new ByteFieldMapper<S, T>(ObjectGetterFactory.toByteGetter(getter), ObjectSetterFactory.toByteSetter(setter));
        }
        if (type.equals(Character.TYPE)) {
            return new CharacterFieldMapper<S, T>(ObjectGetterFactory.toCharGetter(getter), ObjectSetterFactory.toCharacterSetter(setter));
        }
        if (type.equals(Short.TYPE)) {
            return new ShortFieldMapper<S, T>(ObjectGetterFactory.toShortGetter(getter), ObjectSetterFactory.toShortSetter(setter));
        }
        throw new UnsupportedOperationException("Type " + type + " is not primitive");
    }

    public <T, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K, S>> propertyMapping, MapperBuilderErrorHandler mappingErrorHandler) {
        PropertyMeta propertyMeta = propertyMapping.getPropertyMeta();
        Type propertyType = propertyMeta.getPropertyType();
        Setter setter = propertyMeta.getSetter();
        FieldKey key = propertyMapping.getColumnKey();
        Class type = TypeHelper.toClass(propertyType);
        Getter getter = ((FieldMapperColumnDefinition)propertyMapping.getColumnDefinition()).getCustomGetter();
        GetterFactory getterFactory = this.getterFactory;
        if (((FieldMapperColumnDefinition)propertyMapping.getColumnDefinition()).hasCustomFactory()) {
            getterFactory = ((FieldMapperColumnDefinition)propertyMapping.getColumnDefinition()).getCustomGetterFactory();
        }
        if (getter == null) {
            getter = getterFactory.newGetter(propertyType, key, propertyMapping.getColumnDefinition());
        }
        if (getter == null) {
            Type sourceType;
            ClassMeta classMeta = propertyMeta.getPropertyClassMeta();
            InstantiatorDefinition.CompatibilityScorer scorer = this.getCompatibilityScorer(key);
            InstantiatorDefinition id = InstantiatorDefinition.lookForCompatibleOneArgument(classMeta.getInstantiatorDefinitions(), scorer);
            if (id != null && (getter = getterFactory.newGetter(sourceType = id.getParameters()[0].getGenericType(), key, null)) != null) {
                Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id);
                getter = new InstantiatorOnGetter(instantiator, getter);
            }
        }
        if (getter == null) {
            mappingErrorHandler.getterNotFound("Could not find getter for " + key + " type " + propertyType);
            return null;
        }
        if (type.isPrimitive()) {
            return this.primitiveIndexedFieldMapper(type, setter, getter);
        }
        return new FieldMapperImpl(getter, setter);
    }

    private InstantiatorDefinition.CompatibilityScorer getCompatibilityScorer(K key) {
        TypeAffinity ta;
        Class[] affinities;
        if (key instanceof TypeAffinity && (affinities = (ta = (TypeAffinity)key).getAffinities()) != null && affinities.length > 0) {
            return new TypeAffinityCompatibilityScorer(affinities);
        }
        return new DefaultCompatibilityScorer();
    }

    private static class TypeAffinityCompatibilityScorer
    implements InstantiatorDefinition.CompatibilityScorer {
        private final Class<?>[] classes;

        private TypeAffinityCompatibilityScorer(Class<?>[] classes) {
            this.classes = classes;
        }

        @Override
        public int score(InstantiatorDefinition id) {
            Class<?> paramType = TypeHelper.toBoxedClass(id.getParameters()[0].getType());
            for (int i = 0; i < this.classes.length; ++i) {
                Class<?> c = this.classes[i];
                if (!c.isAssignableFrom(paramType)) continue;
                return this.classes.length - i + 10;
            }
            Package aPackage = paramType.getPackage();
            if (aPackage != null && aPackage.getName().equals("java.lang")) {
                return 1;
            }
            return 0;
        }
    }

    private static class DefaultCompatibilityScorer
    implements InstantiatorDefinition.CompatibilityScorer {
        private DefaultCompatibilityScorer() {
        }

        @Override
        public int score(InstantiatorDefinition id) {
            Package aPackage = id.getParameters()[0].getType().getPackage();
            if (aPackage != null && aPackage.getName().equals("java.lang")) {
                return 1;
            }
            return 0;
        }
    }
}

