/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map;

import java.lang.reflect.Type;
import org.sfm.map.FieldKey;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.IgnoreProperty;
import org.sfm.map.column.KeyProperty;
import org.sfm.map.column.RenameProperty;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.Asserts;
import org.sfm.utils.Predicate;

public abstract class ColumnDefinition<K extends FieldKey<K>, CD extends ColumnDefinition<K, CD>> {
    public static final Predicate<PropertyMeta<?, ?>> DEFAULT_APPLIES_TO = new Predicate<PropertyMeta<?, ?>>(){

        @Override
        public boolean test(PropertyMeta<?, ?> propertyMeta) {
            return false;
        }
    };
    private final ColumnProperty[] properties;

    protected ColumnDefinition(ColumnProperty[] properties) {
        this.properties = Asserts.requireNonNull("properties", properties);
    }

    public K rename(K key) {
        RenameProperty rp = this.lookFor(RenameProperty.class);
        if (rp != null) {
            return (K)((FieldKey)key.alias(rp.getName()));
        }
        return key;
    }

    public boolean ignore() {
        return this.has(IgnoreProperty.class);
    }

    public boolean has(Class<? extends ColumnProperty> clazz) {
        return this.lookFor(clazz) != null;
    }

    public boolean isKey() {
        return this.has(KeyProperty.class);
    }

    public Predicate<PropertyMeta<?, ?>> keyAppliesTo() {
        KeyProperty kp = this.lookFor(KeyProperty.class);
        if (kp != null) {
            return kp.getAppliesTo();
        }
        return DEFAULT_APPLIES_TO;
    }

    public CD compose(CD columnDefinition) {
        ColumnDefinition cdi = (ColumnDefinition)Asserts.requireNonNull("columnDefinition", columnDefinition);
        ColumnProperty[] properties = new ColumnProperty[this.properties.length + cdi.properties.length];
        System.arraycopy(cdi.properties, 0, properties, 0, cdi.properties.length);
        System.arraycopy(this.properties, 0, properties, cdi.properties.length, this.properties.length);
        return this.newColumnDefinition(properties);
    }

    public CD add(ColumnProperty ... props) {
        Asserts.requireNonNull("properties", props);
        ColumnProperty[] properties = new ColumnProperty[this.properties.length + props.length];
        System.arraycopy(this.properties, 0, properties, 0, this.properties.length);
        System.arraycopy(props, 0, properties, this.properties.length, props.length);
        return this.newColumnDefinition(properties);
    }

    public <T> T lookFor(Class<T> propClass) {
        for (ColumnProperty cp : this.properties) {
            if (cp == null || !propClass.equals(cp.getClass())) continue;
            return (T)cp;
        }
        return null;
    }

    protected abstract CD newColumnDefinition(ColumnProperty[] var1);

    public CD addRename(String name) {
        return this.add(new RenameProperty(name));
    }

    public CD addIgnore() {
        return this.add(new IgnoreProperty());
    }

    public CD addKey() {
        return this.add(new KeyProperty());
    }

    public CD addKey(Predicate<PropertyMeta<?, ?>> appliesTo) {
        return this.add(new KeyProperty(appliesTo));
    }

    protected void appendToStringBuilder(StringBuilder sb) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.properties[i].toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnDefinition{");
        this.appendToStringBuilder(sb);
        sb.append("}");
        return sb.toString();
    }

    public abstract boolean hasCustomSource();

    public abstract Type getCustomSourceReturnType();
}

