/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.CharacterGetter;

public final class CharacterResultSetGetter
implements CharacterGetter<ResultSet>,
Getter<ResultSet, Character> {
    private final int column;

    public CharacterResultSetGetter(int column) {
        this.column = column;
    }

    @Override
    public char getCharacter(ResultSet target) throws SQLException {
        return (char)target.getInt(this.column);
    }

    @Override
    public Character get(ResultSet target) throws SQLException {
        char c = this.getCharacter(target);
        if (c == '\u0000' && target.wasNull()) {
            return null;
        }
        return Character.valueOf(c);
    }

    public String toString() {
        return "CharacterResultSetGetter{column=" + this.column + '}';
    }
}

