/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import org.sfm.csv.impl.cellreader.StringCellValueReader;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public final class StringArrayConsumer<RH extends RowHandler<String[]>>
implements CellConsumer {
    private final RH handler;
    private String[] currentRow = new String[10];
    private int currentIndex;

    public StringArrayConsumer(RH handler) {
        this.handler = handler;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.currentIndex >= this.currentRow.length) {
            this.doubleSize();
        }
        this.currentRow[this.currentIndex++] = StringCellValueReader.readString(chars, offset, length);
    }

    private void doubleSize() {
        String[] newArray = new String[this.currentRow.length * 2];
        System.arraycopy(this.currentRow, 0, newArray, 0, this.currentIndex);
        this.currentRow = newArray;
    }

    @Override
    public void endOfRow() {
        try {
            String[] result = new String[this.currentIndex];
            System.arraycopy(this.currentRow, 0, result, 0, this.currentIndex);
            this.handler.handle((String[])result);
            this.currentIndex = 0;
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
    }

    public RH handler() {
        return this.handler;
    }

    @Override
    public void end() {
        if (!this.isEmpty()) {
            this.endOfRow();
        }
    }

    private boolean isEmpty() {
        return this.currentIndex == 0;
    }

    public static <RH extends RowHandler<String[]>> StringArrayConsumer<RH> newInstance(RH handler) {
        return new StringArrayConsumer<RH>(handler);
    }
}

