/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import java.io.IOException;
import java.io.Reader;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;
import org.sfm.csv.parser.CsvCharConsumer;

public abstract class AbstractCsvCharConsumer
implements CsvCharConsumer {
    private static final int IN_QUOTE = 4;
    private static final int IN_CR = 2;
    private static final int QUOTE = 1;
    private static final int NONE = 0;
    private static final int TURN_OFF_IN_CR_MASK = -3;
    private static final int ALL_QUOTES = 5;
    protected final CharBuffer csvBuffer;
    protected int _currentIndex;
    private int currentState = 0;

    public AbstractCsvCharConsumer(CharBuffer csvBuffer) {
        this.csvBuffer = csvBuffer;
    }

    @Override
    public final void parseAll(CellConsumer cellConsumer) {
        int bufferLength = this.csvBuffer.getBufferLength();
        for (int i = this._currentIndex; i < bufferLength; ++i) {
            char c = this.csvBuffer.getChar(i);
            this.consumeOneChar(c, i, cellConsumer);
        }
        this._currentIndex = bufferLength;
    }

    protected abstract void consumeOneChar(char var1, int var2, CellConsumer var3);

    protected final void turnOffCrFlag() {
        this.currentState &= 0xFFFFFFFD;
    }

    protected final void newCellIfNotInQuote(int currentIndex, CellConsumer cellConsumer) {
        if (this.isInQuote()) {
            return;
        }
        this.newCell(currentIndex, cellConsumer);
    }

    private boolean isInQuote() {
        return this.currentState == 4;
    }

    protected final boolean handleEndOfLineLF(int currentIndex, CellConsumer cellConsumer) {
        if (!this.isInQuote()) {
            if (this.currentState != 2) {
                this.endOfRow(currentIndex, cellConsumer);
                return true;
            }
            this.csvBuffer.mark(currentIndex + 1);
        }
        return false;
    }

    protected final boolean handleEndOfLineCR(int currentIndex, CellConsumer cellConsumer) {
        if (!this.isInQuote()) {
            this.endOfRow(currentIndex, cellConsumer);
            this.currentState = 2;
            return true;
        }
        return false;
    }

    private void endOfRow(int currentIndex, CellConsumer cellConsumer) {
        this.newCell(currentIndex, cellConsumer);
        cellConsumer.endOfRow();
    }

    protected final void quote(int currentIndex) {
        this.currentState = this.isAllConsumedFromMark(currentIndex) ? 4 : (this.currentState ^= 5);
    }

    private void newCell(int currentIndex, CellConsumer cellConsumer) {
        char[] charBuffer = this.csvBuffer.getCharBuffer();
        int start = this.csvBuffer.getMark();
        int length = currentIndex - start;
        if (charBuffer[start] == this.quoteChar()) {
            length = this.unescape(charBuffer, ++start, length);
        }
        cellConsumer.newCell(charBuffer, start, length);
        this.csvBuffer.mark(currentIndex + 1);
        this.currentState = 0;
    }

    @Override
    public final void finish(CellConsumer cellConsumer) {
        if (!this.isAllConsumedFromMark(this._currentIndex)) {
            this.newCell(this._currentIndex, cellConsumer);
        }
        cellConsumer.end();
    }

    private void shiftCurrentIndex(int mark) {
        this._currentIndex -= mark;
    }

    @Override
    public final boolean fillBuffer(Reader reader) throws IOException {
        this.shiftCurrentIndex(this.csvBuffer.shiftBufferToMark());
        return this.csvBuffer.fillBuffer(reader);
    }

    private boolean isAllConsumedFromMark(int bufferIndex) {
        return bufferIndex < this.csvBuffer.getMark() + 1;
    }

    private int unescape(char[] chars, int offset, int length) {
        char quoteChar = this.quoteChar();
        int j = offset + 1;
        boolean notEscaped = true;
        for (int i = offset + 1; i < offset + length - 1; ++i) {
            boolean bl = notEscaped = chars[i] != quoteChar || !notEscaped;
            if (!notEscaped) continue;
            chars[j++] = chars[i];
        }
        if (chars[offset + length - 1] != quoteChar) {
            chars[j++] = chars[offset + length - 1];
        }
        return j - offset - 1;
    }
}

