/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.primitive;

import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.FloatCellValueReader;
import org.sfm.reflect.primitive.FloatSetter;

public class FloatDelayedCellSetter<T>
implements DelayedCellSetter<T, Float> {
    private final FloatSetter<T> setter;
    private final FloatCellValueReader reader;
    private float value;
    private boolean isNull;

    public FloatDelayedCellSetter(FloatSetter<T> setter, FloatCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public Float consumeValue() {
        return this.isNull ? null : Float.valueOf(this.consumeFloat());
    }

    public Float peekValue() {
        return this.isNull ? null : Float.valueOf(this.value);
    }

    public float consumeFloat() {
        float v = this.value;
        this.value = 0.0f;
        this.isNull = true;
        return v;
    }

    public void set(T t) throws Exception {
        this.setter.setFloat(t, this.consumeValue().floatValue());
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readFloat(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "FloatDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

