/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.ParsingException;
import org.sfm.csv.impl.cellreader.IntegerCellValueReader;

public final class IntegerCellValueReaderImpl
implements IntegerCellValueReader {
    private static final char C_ZERO = '0';
    private static final char C_NINE = '9';
    private static final char C_NEG_SIGN = '-';

    @Override
    public Integer read(char[] chars, int offset, int length, ParsingContext parsingContext) {
        if (length == 0) {
            return null;
        }
        return this.readInt(chars, offset, length, parsingContext);
    }

    @Override
    public int readInt(char[] chars, int offset, int length, ParsingContext parsingContext) {
        return IntegerCellValueReaderImpl.parseInt(chars, offset, length);
    }

    public static int parseInt(char[] chars, int offset, int length) {
        int n = 0;
        boolean negative = false;
        for (int i = offset; i < offset + length; ++i) {
            char b = chars[i];
            if (b >= '0' && b <= '9') {
                n = n * 10 + chars[i] - 48;
                continue;
            }
            if (b == '-' && i == offset) {
                negative = true;
                continue;
            }
            throw new ParsingException("Cannot parse " + new String(chars, offset, length) + " as an int");
        }
        if (negative) {
            n = 0 - n;
        }
        return n;
    }

    public String toString() {
        return "IntegerCellValueReaderImpl{}";
    }
}

