/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.CellValueReader;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.StringCellValueReader;
import org.sfm.reflect.EnumHelper;

public class EnumCellValueReader<E extends Enum<E>>
implements CellValueReader<E> {
    static final char CZERO = '0';
    static final char CNINE = '9';
    private final StringCellValueReader stringCellValueReader = new StringCellValueReader();
    private final Class<E> enumClass;
    private final E[] values;

    public EnumCellValueReader(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.values = EnumHelper.getValues(enumClass);
    }

    @Override
    public E read(char[] chars, int offset, int length, ParsingContext parsingContext) {
        int n = this.parsePositiveNumber(chars, offset, length);
        if (n >= 0 && n < this.values.length) {
            return this.values[n];
        }
        return Enum.valueOf(this.enumClass, this.stringCellValueReader.read(chars, offset, length, parsingContext));
    }

    private int parsePositiveNumber(char[] chars, int offset, int length) {
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            char b = chars[i];
            if (b < '0' || b > '9') {
                return -1;
            }
            n = n * 10 + b - 48;
        }
        return n;
    }

    public String toString() {
        return "EnumCellValueReader{enumClass=" + this.enumClass + '}';
    }
}

