/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CsvCharConsumer;
import org.sfm.csv.parser.CsvStringArrayIterator;
import org.sfm.csv.parser.StringArrayConsumer;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public final class CsvReader
implements Iterable<String[]> {
    private static final CellConsumer DUMMY_CONSUMER = new CellConsumer(){

        @Override
        public void newCell(char[] chars, int offset, int length) {
        }

        @Override
        public void endOfRow() {
        }

        @Override
        public void end() {
        }
    };
    private final Reader reader;
    private final CsvCharConsumer consumer;

    public CsvReader(Reader reader, CsvCharConsumer charConsumer) {
        this.reader = reader;
        this.consumer = charConsumer;
    }

    public <CC extends CellConsumer> CC parseAll(CC cellConsumer) throws IOException {
        do {
            this.consumer.parseAll(cellConsumer);
        } while (this.consumer.fillBuffer(this.reader));
        this.consumer.finish(cellConsumer);
        return cellConsumer;
    }

    public boolean parseRow(CellConsumer cellConsumer) throws IOException {
        do {
            if (!this.consumer.nextRow(cellConsumer)) continue;
            return true;
        } while (this.consumer.fillBuffer(this.reader));
        this.consumer.finish(cellConsumer);
        return false;
    }

    public void skipRows(int n) throws IOException {
        this.parseRows(DUMMY_CONSUMER, n);
    }

    public <CC extends CellConsumer> CC parseRows(CC cellConsumer, int limit) throws IOException {
        for (int i = 0; i < limit; ++i) {
            this.parseRow(cellConsumer);
        }
        return cellConsumer;
    }

    public <RH extends RowHandler<String[]>> RH read(RH handler) throws IOException {
        this.parseAll(new StringArrayConsumer<RH>(handler));
        return handler;
    }

    public <RH extends RowHandler<String[]>> RH read(RH handler, int limit) throws IOException {
        this.parseRows(new StringArrayConsumer<RH>(handler), limit);
        return handler;
    }

    @Override
    public Iterator<String[]> iterator() {
        return new CsvStringArrayIterator(this);
    }

    public Stream<String[]> stream() {
        return StreamSupport.stream(new CsvStringArraySpliterator(this), false);
    }

    private static class CsvStringArraySpliterator
    implements Spliterator<String[]> {
        private final CsvReader reader;

        public CsvStringArraySpliterator(CsvReader csvReader) {
            this.reader = csvReader;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String[]> action) {
            try {
                return this.reader.parseRow(new StringArrayConsumer<RowHandler<String[]>>(strings -> action.accept((String[])strings)));
            }
            catch (IOException e) {
                return (Boolean)ErrorHelper.rethrow(e);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super String[]> action) {
            try {
                this.reader.parseAll(new StringArrayConsumer<RowHandler<String[]>>(strings -> action.accept((String[])strings)));
            }
            catch (IOException e) {
                ErrorHelper.rethrow(e);
            }
        }

        @Override
        public Spliterator<String[]> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }
    }
}

