/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.util.CheckedConsumer;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTemplateCrud<T, K> {
    private final JdbcTemplate jdbcTemplate;
    private final Crud<T, K> crud;

    public JdbcTemplateCrud(JdbcTemplate jdbcTemplate, Crud<T, K> crud) {
        this.jdbcTemplate = jdbcTemplate;
        this.crud = crud;
    }

    public void create(final T value) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.create(connection, value);
                return null;
            }
        });
    }

    public void create(final Collection<T> values) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.create(connection, values);
                return null;
            }
        });
    }

    public <RH extends CheckedConsumer<? super K>> RH create(final T value, final RH keyConsumer) throws SQLException {
        return (RH)((CheckedConsumer)this.jdbcTemplate.execute(new ConnectionCallback<RH>(){

            public RH doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.create(connection, value, keyConsumer);
            }
        }));
    }

    public <RH extends CheckedConsumer<? super K>> RH create(final Collection<T> values, final RH keyConsumer) throws SQLException {
        return (RH)((CheckedConsumer)this.jdbcTemplate.execute(new ConnectionCallback<RH>(){

            public RH doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.create(connection, values, keyConsumer);
            }
        }));
    }

    public T read(final K key) throws SQLException {
        return (T)this.jdbcTemplate.execute(new ConnectionCallback<T>(){

            public T doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.read(connection, key);
            }
        });
    }

    public <RH extends CheckedConsumer<? super T>> RH read(final Collection<K> keys, final RH consumer) throws SQLException {
        return (RH)((CheckedConsumer)this.jdbcTemplate.execute(new ConnectionCallback<RH>(){

            public RH doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.read(connection, keys, consumer);
            }
        }));
    }

    public void update(final T value) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.update(connection, value);
                return null;
            }
        });
    }

    public void update(final Collection<T> values) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.update(connection, values);
                return null;
            }
        });
    }

    public void delete(final K key) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.delete(connection, key);
                return null;
            }
        });
    }

    public void delete(final List<K> keys) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.delete(connection, keys);
                return null;
            }
        });
    }

    public void createOrUpdate(final T value) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.createOrUpdate(connection, value);
                return null;
            }
        });
    }

    public void createOrUpdate(final Collection<T> values) throws SQLException {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                JdbcTemplateCrud.this.crud.createOrUpdate(connection, values);
                return null;
            }
        });
    }

    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(final T value, final RH keyConsumer) throws SQLException {
        return (RH)((CheckedConsumer)this.jdbcTemplate.execute(new ConnectionCallback<RH>(){

            public RH doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.createOrUpdate(connection, value, keyConsumer);
            }
        }));
    }

    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(final Collection<T> values, final RH keyConsumer) throws SQLException {
        return (RH)((CheckedConsumer)this.jdbcTemplate.execute(new ConnectionCallback<RH>(){

            public RH doInConnection(Connection connection) throws SQLException, DataAccessException {
                return JdbcTemplateCrud.this.crud.createOrUpdate(connection, values, keyConsumer);
            }
        }));
    }
}

