/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.spring;

import java.util.ArrayList;
import java.util.Iterator;
import org.sfm.jdbc.spring.PlaceHolderValueGetterSource;
import org.sfm.jdbc.spring.SqlParameterSourceImpl;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SqlParameterSourceFactory<T> {
    private final PlaceHolderValueGetterSource<T> placeHolderValueGetterSource;

    public SqlParameterSourceFactory(PlaceHolderValueGetterSource<T> placeHolderValueGetterSource) {
        this.placeHolderValueGetterSource = placeHolderValueGetterSource;
    }

    public SqlParameterSource newSqlParameterSource(T value) {
        return new SqlParameterSourceImpl<T>(this.placeHolderValueGetterSource, value);
    }

    public SqlParameterSource[] newSqlParameterSources(Iterable<T> values) {
        return this.newSqlParameterSources(values.iterator());
    }

    public SqlParameterSource[] newSqlParameterSources(Iterator<T> values) {
        ArrayList<SqlParameterSource> sources = new ArrayList<SqlParameterSource>();
        while (values.hasNext()) {
            sources.add(this.newSqlParameterSource(values.next()));
        }
        return sources.toArray(new SqlParameterSource[sources.size()]);
    }

    public SqlParameterSource[] newSqlParameterSources(T[] values) {
        ArrayList<SqlParameterSource> sources = new ArrayList<SqlParameterSource>();
        for (T value : values) {
            sources.add(this.newSqlParameterSource(value));
        }
        return sources.toArray(new SqlParameterSource[sources.size()]);
    }
}

