/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaLocalDateTimeFromObjectGetter<S>
implements Getter<S, LocalDateTime> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaLocalDateTimeFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public LocalDateTime get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone).toLocalDateTime();
        }
        if (o instanceof LocalDateTime) {
            return (LocalDateTime)o;
        }
        if (o instanceof TemporalAccessor) {
            return LocalDateTime.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to LocalDateTime");
    }

    public String toString() {
        return "JavaLocalDateTimeFromObjectGetter{getter=" + this.getter + '}';
    }
}

