/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.writer;

import java.lang.reflect.Type;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.impl.writer.BooleanAppendableSetter;
import org.sfm.csv.impl.writer.ByteAppendableSetter;
import org.sfm.csv.impl.writer.CellWriter;
import org.sfm.csv.impl.writer.CharacterAppendableSetter;
import org.sfm.csv.impl.writer.DoubleAppendableSetter;
import org.sfm.csv.impl.writer.EnumOrdinalAppendableSetter;
import org.sfm.csv.impl.writer.FloatAppendableSetter;
import org.sfm.csv.impl.writer.FormattingAppender;
import org.sfm.csv.impl.writer.IntegerAppendableSetter;
import org.sfm.csv.impl.writer.JodaTimeFormattingAppender;
import org.sfm.csv.impl.writer.LongAppendableSetter;
import org.sfm.csv.impl.writer.ObjectAppendableSetter;
import org.sfm.csv.impl.writer.ShortAppendableSetter;
import org.sfm.csv.impl.writer.time.JavaTimeFormattingAppender;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.FieldMapper;
import org.sfm.map.MappingContext;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.EnumOrdinalFormatProperty;
import org.sfm.map.column.FormatProperty;
import org.sfm.map.column.joda.JodaDateTimeFormatterProperty;
import org.sfm.map.column.time.JavaDateTimeFormatterProperty;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.impl.PropertyMapping;
import org.sfm.map.impl.context.MappingContextFactoryBuilder;
import org.sfm.map.impl.fieldmapper.BooleanFieldMapper;
import org.sfm.map.impl.fieldmapper.ByteFieldMapper;
import org.sfm.map.impl.fieldmapper.CharacterFieldMapper;
import org.sfm.map.impl.fieldmapper.DoubleFieldMapper;
import org.sfm.map.impl.fieldmapper.FieldMapperImpl;
import org.sfm.map.impl.fieldmapper.FloatFieldMapper;
import org.sfm.map.impl.fieldmapper.IntFieldMapper;
import org.sfm.map.impl.fieldmapper.LongFieldMapper;
import org.sfm.map.impl.fieldmapper.ShortFieldMapper;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.primitive.BooleanGetter;
import org.sfm.reflect.primitive.ByteGetter;
import org.sfm.reflect.primitive.CharacterGetter;
import org.sfm.reflect.primitive.DoubleGetter;
import org.sfm.reflect.primitive.FloatGetter;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.reflect.primitive.LongGetter;
import org.sfm.reflect.primitive.ShortGetter;
import org.sfm.utils.Supplier;

public class DefaultFieldAppenderFactory {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DefaultFieldAppenderFactory DEFAULT_FIELD_APPENDER_FACTORY = new DefaultFieldAppenderFactory();

    public static DefaultFieldAppenderFactory instance() {
        return DEFAULT_FIELD_APPENDER_FACTORY;
    }

    public <T, P> FieldMapper<T, Appendable> newFieldAppender(PropertyMapping<T, P, CsvColumnKey, ? extends ColumnDefinition<CsvColumnKey, ?>> pm, CellWriter cellWriter, MappingContextFactoryBuilder builder) {
        if (pm == null) {
            throw new NullPointerException("pm is null");
        }
        Type type = pm.getPropertyMeta().getPropertyType();
        Getter getter = pm.getPropertyMeta().getGetter();
        ColumnDefinition columnDefinition = pm.getColumnDefinition();
        if (TypeHelper.isPrimitive(type) && !columnDefinition.has(FormatProperty.class)) {
            if (getter instanceof BooleanGetter) {
                return new BooleanFieldMapper((BooleanGetter)((Object)getter), new BooleanAppendableSetter(cellWriter));
            }
            if (getter instanceof ByteGetter) {
                return new ByteFieldMapper((ByteGetter)((Object)getter), new ByteAppendableSetter(cellWriter));
            }
            if (getter instanceof CharacterGetter) {
                return new CharacterFieldMapper((CharacterGetter)((Object)getter), new CharacterAppendableSetter(cellWriter));
            }
            if (getter instanceof ShortGetter) {
                return new ShortFieldMapper((ShortGetter)((Object)getter), new ShortAppendableSetter(cellWriter));
            }
            if (getter instanceof IntGetter) {
                return new IntFieldMapper((IntGetter)((Object)getter), new IntegerAppendableSetter(cellWriter));
            }
            if (getter instanceof LongGetter) {
                return new LongFieldMapper((LongGetter)((Object)getter), new LongAppendableSetter(cellWriter));
            }
            if (getter instanceof FloatGetter) {
                return new FloatFieldMapper((FloatGetter)((Object)getter), new FloatAppendableSetter(cellWriter));
            }
            if (getter instanceof DoubleGetter) {
                return new DoubleFieldMapper((DoubleGetter)((Object)getter), new DoubleAppendableSetter(cellWriter));
            }
        }
        Setter<Appendable, Enum> setter = null;
        if (TypeHelper.isEnum(type) && columnDefinition.has(EnumOrdinalFormatProperty.class)) {
            setter = new EnumOrdinalAppendableSetter(cellWriter);
        }
        Format format = null;
        if (columnDefinition.has(FormatProperty.class)) {
            format = columnDefinition.lookFor(FormatProperty.class).format();
        } else if (TypeHelper.areEquals(type, Date.class)) {
            String df = DEFAULT_DATE_FORMAT;
            DateFormatProperty dfp = columnDefinition.lookFor(DateFormatProperty.class);
            if (dfp != null) {
                df = dfp.getPattern();
            }
            format = new SimpleDateFormat(df);
        } else {
            if (TypeHelper.isAssignable(TemporalAccessor.class, type) && columnDefinition.has(JavaDateTimeFormatterProperty.class)) {
                return new JavaTimeFormattingAppender(getter, columnDefinition.lookFor(JavaDateTimeFormatterProperty.class).getFormatter(), cellWriter);
            }
            if (JodaTimeClasses.isJoda((Type)type)) {
                if (columnDefinition.has(JodaDateTimeFormatterProperty.class)) {
                    return new JodaTimeFormattingAppender(getter, columnDefinition.lookFor(JodaDateTimeFormatterProperty.class).getFormatter(), cellWriter);
                }
                if (columnDefinition.has(DateFormatProperty.class)) {
                    return new JodaTimeFormattingAppender(getter, columnDefinition.lookFor(DateFormatProperty.class).getPattern(), cellWriter);
                }
            }
        }
        if (format != null) {
            final Format f = format;
            builder.addSupplier(((CsvColumnKey)pm.getColumnKey()).getIndex(), new Supplier<Format>(){

                @Override
                public Format get() {
                    return (Format)f.clone();
                }
            });
            return new FormattingAppender(getter, new MappingContextFormatGetter(((CsvColumnKey)pm.getColumnKey()).getIndex()), cellWriter);
        }
        if (setter == null) {
            setter = new ObjectAppendableSetter(cellWriter);
        }
        return new FieldMapperImpl(getter, setter);
    }

    private static class MappingContextFormatGetter<T>
    implements Getter<MappingContext<? super T>, Format> {
        private final int index;

        public MappingContextFormatGetter(int index) {
            this.index = index;
        }

        @Override
        public Format get(MappingContext<? super T> target) throws Exception {
            return (Format)target.context(this.index);
        }
    }
}

