/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.property.ArrayIndexStartAtProperty;

public abstract class AbstractIndexPropertyFinder<T>
extends PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final Map<Integer, IndexedElement<T, ?>> elements = new HashMap();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta, boolean selfScoreFullName) {
        super(selfScoreFullName);
        this.classMeta = classMeta;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchIndex();
        if (indexedColumn != null) {
            int startIndex = 0;
            for (Object prop : properties) {
                if (!(prop instanceof ArrayIndexStartAtProperty)) continue;
                startIndex = ((ArrayIndexStartAtProperty)prop).startIndex;
                break;
            }
            indexedColumn = indexedColumn.alignTo(startIndex);
            this.lookForAgainstColumn(indexedColumn, properties, matchingProperties, score.arrayIndex(indexedColumn), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
        }
        if (indexedColumn == null || indexedColumn.partial) {
            this.extrapolateIndex(propertyNameMatcher, properties, matchingProperties, score.speculative(), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
            this.speculativeMatching(propertyNameMatcher, properties, matchingProperties, score.speculative(), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
        }
    }

    protected void lookForAgainstColumn(IndexedColumn indexedColumn, Object[] properties, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return;
        }
        final IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedElement == null) {
            return;
        }
        if (indexedColumn.getSubPropertyNameMatcher() == null) {
            matchingProperties.found(indexedElement.getPropertyMeta(), new Runnable(){

                @Override
                public void run() {
                    if (!indexedElement.hasProperty("{this}")) {
                        indexedElement.addProperty("{this}");
                    }
                }
            }, score.self(indexedElement.getElementClassMeta(), indexedColumn.getIndexProperty()), typeAffinityScorer);
            return;
        }
        PropertyFinder<?> eltPropertyFinder = indexedElement.getPropertyFinder();
        if (eltPropertyFinder == null) {
            return;
        }
        propertyFinderTransformer.apply(eltPropertyFinder).lookForProperties(indexedColumn.getSubPropertyNameMatcher(), properties, new PropertyFinder.FoundProperty(){

            public void found(final PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                SubPropertyMeta subProperty = new SubPropertyMeta(AbstractIndexPropertyFinder.this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), propertyMeta);
                matchingProperties.found(subProperty, new Runnable(){

                    @Override
                    public void run() {
                        selectionCallback.run();
                        indexedElement.addProperty(propertyMeta);
                    }
                }, score, typeAffinityScorer);
            }
        }, score.matches(indexedColumn.getIndexProperty()), true, propertyFinderTransformer, typeAffinityScorer, propertyFilter);
    }

    private void speculativeMatching(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        PropertyNameMatch speculativeMatch = propertyNameMatcher.speculativeMatch();
        if (speculativeMatch != null) {
            this.extrapolateIndex(speculativeMatch.getLeftOverMatcher(), properties, foundProperty, score.speculative(), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
        }
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    protected abstract void extrapolateIndex(PropertyNameMatcher var1, Object[] var2, PropertyFinder.FoundProperty<T> var3, PropertyMatchingScore var4, PropertyFinder.PropertyFinderTransformer var5, PropertyFinder.TypeAffinityScorer var6, PropertyFinder.PropertyFilter var7);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }

    @Override
    public Type getOwnerType() {
        return this.classMeta.getType();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        PropertyFinder<?> ie = this.lookForPropertyFinder(owner);
        if (ie != null) {
            return ie;
        }
        throw new IllegalArgumentException("Unexpected owner " + owner);
    }

    private PropertyFinder<?> lookForPropertyFinder(PropertyMeta<?, ?> owner) {
        ArrayList<Integer> indicies = new ArrayList<Integer>(this.elements.keySet());
        Collections.sort(indicies);
        for (Integer key : indicies) {
            IndexedElement<T, ?> ie = this.elements.get(key);
            if (!this.indexMatches(ie.getPropertyMeta(), owner)) continue;
            return ie.getPropertyFinder();
        }
        return null;
    }

    protected abstract boolean indexMatches(PropertyMeta<T, ?> var1, PropertyMeta<?, ?> var2);

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyMeta<?, ?> ownerProperty = subPropertyMeta.getOwnerProperty();
        PropertyFinder<?> ie = this.lookForPropertyFinder(ownerProperty);
        if (ie != null) {
            return ie;
        }
        return this.registerProperty(subPropertyMeta);
    }

    protected abstract PropertyFinder<?> registerProperty(SubPropertyMeta<?, ?, ?> var1);
}

