/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;

public class PropertyMatchingScore
implements Comparable<PropertyMatchingScore> {
    private final int selfNumberOfProperties;
    private final int nbMatch;
    private final int nbPartialMatch;
    private final int verticalDepth;
    private final int horizontalDepth;
    private final boolean selfScoreFullName;
    private final boolean notMatched;

    private PropertyMatchingScore(int selfNumberOfProperties, int nbMatch, int nbPartialMatch, int verticalDepth, int horizontalDepth, boolean selfScoreFullName, boolean notMatched) {
        this.nbMatch = nbMatch;
        this.selfNumberOfProperties = selfNumberOfProperties;
        this.nbPartialMatch = nbPartialMatch;
        this.verticalDepth = verticalDepth;
        this.horizontalDepth = horizontalDepth;
        this.selfScoreFullName = selfScoreFullName;
        this.notMatched = notMatched;
    }

    @Override
    public int compareTo(PropertyMatchingScore o) {
        if (this.notMatched && !o.notMatched) {
            return 1;
        }
        if (!this.notMatched && o.notMatched) {
            return -1;
        }
        if (this.selfNumberOfProperties != o.selfNumberOfProperties && this.nbPartialMatch != o.nbPartialMatch) {
            if (this.nbMatch < o.nbMatch) {
                return 1;
            }
            if (this.nbMatch > o.nbMatch) {
                return -1;
            }
        }
        if (this.nbPartialMatch < o.nbPartialMatch) {
            return -1;
        }
        if (this.nbPartialMatch > o.nbPartialMatch) {
            return 1;
        }
        if (this.nbMatch < o.nbMatch) {
            return 1;
        }
        if (this.nbMatch > o.nbMatch) {
            return -1;
        }
        if (this.verticalDepth < o.verticalDepth) {
            return -1;
        }
        if (this.verticalDepth > o.verticalDepth) {
            return 1;
        }
        if (this.horizontalDepth < o.horizontalDepth) {
            return -1;
        }
        if (this.horizontalDepth > o.horizontalDepth) {
            return 1;
        }
        if (this.selfNumberOfProperties < o.selfNumberOfProperties) {
            return -1;
        }
        if (this.selfNumberOfProperties > o.selfNumberOfProperties) {
            return 1;
        }
        return 0;
    }

    public PropertyMatchingScore speculative() {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName, this.notMatched);
    }

    public PropertyMatchingScore matches(PropertyNameMatch property) {
        return this.partialMatch(property.score, property.skippedLetters);
    }

    public PropertyMatchingScore matches(PropertyNameMatcher property) {
        return this.matches(property.asScore());
    }

    public PropertyMatchingScore matches(String property) {
        int score = DefaultPropertyNameMatcher.toScore(property);
        return this.matches(score);
    }

    public PropertyMatchingScore matches(int score) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch + score, this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName, this.notMatched);
    }

    public PropertyMatchingScore partialMatch(int score, int pScore) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch + score, this.nbPartialMatch + pScore, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName, this.notMatched);
    }

    public String toString() {
        return "PropertyMatchingScore{selfNumberOfProperties=" + this.selfNumberOfProperties + ", nbMatch=" + this.nbMatch + ", nbPartialMatch=" + this.nbPartialMatch + ", verticalDepth=" + this.verticalDepth + ", horizontalDepth=" + this.horizontalDepth + ", selfScoreFullName=" + this.selfScoreFullName + ", notMatched=" + this.notMatched + '}';
    }

    public PropertyMatchingScore arrayIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + i, this.selfScoreFullName, this.notMatched);
    }

    public PropertyMatchingScore speculativeArrayIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.nbPartialMatch, this.verticalDepth + i, this.horizontalDepth, this.selfScoreFullName, this.notMatched);
    }

    public PropertyMatchingScore tupleIndex(int i) {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + i, this.selfScoreFullName, this.notMatched);
    }

    public PropertyMatchingScore self(int numberOfProperties, String propName) {
        return new PropertyMatchingScore(this.selfNumberOfProperties + numberOfProperties, this.nbMatch + this.selfNbMatch(numberOfProperties, propName), this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName, this.notMatched);
    }

    private int selfNbMatch(int numberOfProperties, String propName) {
        return this.selfScoreFullName && numberOfProperties == 0 ? propName.length() : 0;
    }

    public PropertyMatchingScore self(ClassMeta propertyMeta, String propName) {
        return this.self(propertyMeta.getNumberOfProperties(), propName);
    }

    public PropertyMatchingScore notMatch() {
        return new PropertyMatchingScore(this.selfNumberOfProperties, this.nbMatch, this.nbPartialMatch, this.verticalDepth, this.horizontalDepth + 1, this.selfScoreFullName, true);
    }

    public static PropertyMatchingScore newInstance(boolean selfScoreFullName) {
        return new PropertyMatchingScore(0, 0, 0, 0, 0, selfScoreFullName, false);
    }
}

