/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.converter.ContextFactory;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.MapElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.MapKeyValueElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcherKeyValuePair;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.property.MapTypeProperty;
import org.simpleflatmapper.util.Predicate;

public class MapPropertyFinder<T extends Map<K, V>, K, V>
extends PropertyFinder<T> {
    public static int NONE = 0;
    public static int COLUMN_AS_KEY = 1;
    public static int KEY_VALUE = 2;
    private final ClassMeta<MapKeyValueElementPropertyMeta.KeyValue<K, V>> keyValueClassMeta;
    private final ClassMeta<V> valueMetaData;
    private final ClassMeta<T> mapMeta;
    private final ContextualConverter<? super CharSequence, ? extends K> keyConverter;
    private final ContextFactory keyContextFactory;
    private final Map<PropertyNameMatcher, PropertyFinder<V>> finders = new HashMap<PropertyNameMatcher, PropertyFinder<V>>();
    private final Map<PropertyMeta<?, ?>, PropertyFinder<?>> findersByKey = new HashMap();
    private final Map<String, MapElementPropertyMeta<?, K, V>> keys = new HashMap();
    private final PropertyFinder<MapKeyValueElementPropertyMeta.KeyValue<K, V>> keyValuePropertyFinder;
    private final Type keyValueType;
    private final MapKeyValueElementPropertyMeta<T, K, V> elementPropertyMeta;
    private int keyValueMode = NONE;

    public MapPropertyFinder(ClassMeta<T> mapMeta, ClassMeta<V> valueMetaData, ContextualConverter<? super CharSequence, ? extends K> keyConverter, ContextFactory keyContextFactory, Predicate<PropertyMeta<?, ?>> propertyFilter, boolean selfScoreFullName) {
        super(propertyFilter, selfScoreFullName);
        this.mapMeta = mapMeta;
        this.valueMetaData = valueMetaData;
        this.keyConverter = keyConverter;
        this.keyValueType = this.getKeyValueType(mapMeta);
        this.keyValueClassMeta = mapMeta.getReflectionService().getClassMeta(this.keyValueType);
        this.keyContextFactory = keyContextFactory;
        this.keyValuePropertyFinder = this.keyValueClassMeta.newPropertyFinder(propertyFilter);
        this.elementPropertyMeta = new MapKeyValueElementPropertyMeta(mapMeta.getType(), valueMetaData.getReflectionService(), this.keyValueType);
    }

    private Type getKeyValueType(ClassMeta<T> mapMeta) {
        final Type mapType = mapMeta.getType();
        if (mapType instanceof ParameterizedType) {
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return ((ParameterizedType)mapType).getActualTypeArguments();
                }

                @Override
                public Type getRawType() {
                    return MapKeyValueElementPropertyMeta.KeyValue.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
        }
        return MapKeyValueElementPropertyMeta.KeyValue.class;
    }

    @Override
    public void lookForProperties(final PropertyNameMatcher propertyNameMatcher, Object[] properties, final PropertyFinder.FoundProperty matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        if (this.isKeyValueEnabled(properties)) {
            propertyFinderTransformer.apply(this.keyValuePropertyFinder).lookForProperties(propertyNameMatcher, properties, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                    Runnable sCallback = new Runnable(){

                        @Override
                        public void run() {
                            selectionCallback.run();
                            MapPropertyFinder.this.keyValueMode = KEY_VALUE;
                            MapPropertyFinder.this.findersByKey.put(MapPropertyFinder.this.elementPropertyMeta, MapPropertyFinder.this.keyValuePropertyFinder);
                        }
                    };
                    matchingProperties.found(new SubPropertyMeta(propertyMeta.getReflectService(), MapPropertyFinder.this.elementPropertyMeta, propertyMeta), sCallback, score.matches(propertyNameMatcher), typeAffinityScorer);
                }
            }, score, false, propertyFinderTransformer, typeAffinityScorer);
        }
        if (this.isColunnKeyEnabled(properties)) {
            for (PropertyNameMatcherKeyValuePair keyValue : propertyNameMatcher.keyValuePairs()) {
                final PropertyNameMatcher keyMatcher = keyValue.getKey();
                PropertyNameMatcher valueMatcher = keyValue.getValue();
                final PropertyFinder<V> propertyFinder = this.getPropertyFinder(keyMatcher);
                propertyFinderTransformer.apply(propertyFinder).lookForProperties(valueMatcher, properties, new PropertyFinder.FoundProperty<V>(){

                    @Override
                    public <P extends PropertyMeta<V, ?>> void found(P propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                        final PropertyMeta keyProperty = MapPropertyFinder.this.keyProperty(keyMatcher);
                        Runnable sCallback = new Runnable(){

                            @Override
                            public void run() {
                                MapPropertyFinder.this.finders.put(keyMatcher, propertyFinder);
                                MapPropertyFinder.this.findersByKey.put(keyProperty, propertyFinder);
                                selectionCallback.run();
                                MapPropertyFinder.this.keyValueMode = COLUMN_AS_KEY;
                            }
                        };
                        if (keyProperty != null) {
                            if (propertyMeta instanceof SelfPropertyMeta) {
                                matchingProperties.found(keyProperty, sCallback, score.self(keyProperty.getPropertyClassMeta(), keyMatcher.toString()), typeAffinityScorer);
                            } else {
                                matchingProperties.found(MapPropertyFinder.this.newSubPropertyMeta(keyProperty, propertyMeta), sCallback, score.matches(keyMatcher), typeAffinityScorer);
                            }
                        }
                    }
                }, score, true, propertyFinderTransformer, typeAffinityScorer);
            }
        }
    }

    private boolean isColunnKeyEnabled(Object[] properties) {
        return this.keyConverter != null || this.keyValueMode == COLUMN_AS_KEY || this.keyValueMode != KEY_VALUE && MapTypeProperty.isColumnKeyEnabled(properties);
    }

    private boolean isKeyValueEnabled(Object[] properties) {
        return this.keyConverter == null || this.keyValueMode == KEY_VALUE || this.keyValueMode != COLUMN_AS_KEY && MapTypeProperty.isKeyValueEnabled(properties);
    }

    private PropertyFinder<V> getPropertyFinder(PropertyNameMatcher keyMatcher) {
        PropertyFinder<V> propertyFinder = this.finders.get(keyMatcher);
        if (propertyFinder == null) {
            propertyFinder = this.valueMetaData.newPropertyFinder(this.propertyFilter);
        }
        return propertyFinder;
    }

    private <E> PropertyMeta<T, E> newSubPropertyMeta(PropertyMeta<T, ?> keyProperty, PropertyMeta<V, ?> propertyMeta) {
        return new SubPropertyMeta(this.valueMetaData.getReflectionService(), keyProperty, propertyMeta);
    }

    private <E> PropertyMeta<T, E> keyProperty(PropertyNameMatcher propertyNameMatcher) {
        String keyStringValue = propertyNameMatcher.toString();
        MapElementPropertyMeta propertyMeta = this.keys.get(keyStringValue);
        if (propertyMeta == null) {
            Object key;
            try {
                key = this.keyConverter.convert((Object)keyStringValue, this.keyContextFactory.newContext());
            }
            catch (Exception e) {
                return null;
            }
            MapElementPropertyMeta mapElementPropertyMeta = new MapElementPropertyMeta(propertyNameMatcher, this.mapMeta.getType(), this.valueMetaData.getReflectionService(), this.valueMetaData, key);
            this.keys.put(keyStringValue, mapElementPropertyMeta);
            propertyMeta = mapElementPropertyMeta;
        }
        return propertyMeta;
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.mapMeta.getInstantiatorDefinitions();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.findersByKey.get(owner);
    }

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        return this.getSubPropertyFinder(subPropertyMeta.getOwnerProperty());
    }

    @Override
    public Type getOwnerType() {
        return this.mapMeta.getType();
    }
}

