/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.ReflectionInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.asm.AsmInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.BuilderInstantiatorDefinitionFactory;
import org.simpleflatmapper.reflect.impl.JavaLangClassMetaFactoryProducer;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.instantiator.KotlinDefaultConstructorInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.FastTupleClassMeta;
import org.simpleflatmapper.reflect.meta.MapClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.OptionalClassMeta;
import org.simpleflatmapper.reflect.meta.PassThroughClassMeta;
import org.simpleflatmapper.reflect.meta.TupleClassMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ProducerServiceLoader;
import org.simpleflatmapper.util.TupleHelper;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public class ReflectionService {
    private static final UnaryFactory<ReflectionService, ClassMeta<?>>[] predefined = ReflectionService.getPredifinedClassMetaFactory();
    private static final Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>[] predefinedBuilderProducers = ReflectionService.getPredifinedBuilderProducers();
    private final ObjectSetterFactory objectSetterFactory;
    private final ObjectGetterFactory objectGetterFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final AsmFactory asmFactory;
    private final AliasProvider aliasProvider;
    private final boolean builderIgnoresNullValues;
    private final boolean selfScoreFullName;
    private final ConcurrentMap<Type, ClassMeta<?>> metaCache = new ConcurrentHashMap();
    private final ConcurrentMap<String, UnaryFactory<Type, Member>> builderMethods = new ConcurrentHashMap<String, UnaryFactory<Type, Member>>();
    private static final AsmFactory _asmFactory = new AsmFactory(Thread.currentThread().getContextClassLoader());

    private static Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>[] getPredifinedBuilderProducers() {
        final ArrayList list = new ArrayList();
        Consumer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>> consumer = new Consumer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>>(){

            public void accept(Consumer<BiConsumer<String, UnaryFactory<Type, Member>>> biConsumerConsumer) {
                list.add(biConsumerConsumer);
            }
        };
        ProducerServiceLoader.produceFromServiceLoader(BuilderProducer.class, (Consumer)consumer);
        consumer.accept((Object)new Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>(){

            public void accept(BiConsumer<String, UnaryFactory<Type, Member>> biConsumer) {
                biConsumer.accept((Object)"javax.money.MonetaryAmount", (Object)new DefaultBuilderSupplier("javax.money.Monetary", "getDefaultAmountFactory"));
            }
        });
        return list.toArray(new Consumer[0]);
    }

    private static UnaryFactory<ReflectionService, ClassMeta<?>>[] getPredifinedClassMetaFactory() {
        final ArrayList list = new ArrayList();
        Consumer consumer = new Consumer<UnaryFactory<ReflectionService, ClassMeta<?>>>(){

            public void accept(UnaryFactory<ReflectionService, ClassMeta<?>> reflectionServiceClassMetaUnaryFactory) {
                list.add(reflectionServiceClassMetaUnaryFactory);
            }
        };
        new JavaLangClassMetaFactoryProducer().produce(consumer);
        ProducerServiceLoader.produceFromServiceLoader(ClassMetaFactoryProducer.class, (Consumer)consumer);
        return list.toArray(new UnaryFactory[0]);
    }

    public ReflectionService(AsmFactory asmFactory) {
        this(new ObjectSetterFactory(asmFactory), new ObjectGetterFactory(asmFactory), new InstantiatorFactory(asmFactory), asmFactory, AliasProviderService.getAliasProvider(), true, false);
    }

    private ReflectionService(ObjectSetterFactory objectSetterFactory, ObjectGetterFactory objectGetterFactory, InstantiatorFactory instantiatorFactory, AsmFactory asmFactory, AliasProvider aliasProvider, boolean builderIgnoresNullValues, boolean selfScoreFullName) {
        this.objectSetterFactory = objectSetterFactory;
        this.objectGetterFactory = objectGetterFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.asmFactory = asmFactory;
        this.aliasProvider = aliasProvider;
        this.builderIgnoresNullValues = builderIgnoresNullValues;
        this.selfScoreFullName = selfScoreFullName;
        this.initPredefined();
    }

    private void initPredefined() {
        for (UnaryFactory<ReflectionService, ClassMeta<?>> unaryFactory : predefined) {
            ClassMeta classMeta = (ClassMeta)unaryFactory.newInstance((Object)this);
            this.metaCache.put(classMeta.getType(), classMeta);
        }
        for (UnaryFactory<ReflectionService, ClassMeta<?>> unaryFactory : predefinedBuilderProducers) {
            unaryFactory.accept((Object)new BiConsumer<String, UnaryFactory<Type, Member>>(){

                public void accept(String s, UnaryFactory<Type, Member> typeMemberUnaryFactory) {
                    ReflectionService.this.builderMethods.put(s, typeMemberUnaryFactory);
                }
            });
        }
    }

    public void registerClassMeta(Type type, ClassMeta<?> classMeta) {
        this.metaCache.put(type, classMeta);
    }

    public ObjectSetterFactory getObjectSetterFactory() {
        return this.objectSetterFactory;
    }

    public InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    public boolean isAsmActivated() {
        return this.asmFactory != null;
    }

    public AsmFactory getAsmFactory() {
        return this.asmFactory;
    }

    public <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public <T> ClassMeta<T> getClassMeta(Type target) {
        Asserts.requireNonNull((String)"target", (Object)target);
        ClassMeta<T> meta = (ClassMeta<T>)this.metaCache.get(target);
        if (meta == null) {
            meta = this.newClassMeta(target);
            Asserts.requireNonNull((String)"meta", meta);
            this.metaCache.putIfAbsent(target, meta);
        }
        return meta;
    }

    private <T> ClassMeta<T> newClassMeta(Type target) {
        Type[] upperBounds;
        Class clazz = TypeHelper.toClass((Type)target);
        if (target instanceof WildcardType && (upperBounds = ((WildcardType)target).getUpperBounds()).length == 1) {
            target = upperBounds[0];
        }
        if (clazz.isArray()) {
            return this.newArrayMeta(clazz);
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return new OptionalClassMeta(target, this);
        }
        if (clazz.isAnnotationPresent(PassThrough.class)) {
            return new PassThroughClassMeta(target, this);
        }
        if (TupleHelper.isTuple((Type)target)) {
            return new TupleClassMeta(target, this);
        }
        if (this.isFastTuple(clazz)) {
            return new FastTupleClassMeta(target, this);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.newMapMeta(target);
        }
        if (ArrayClassMeta.supports(target)) {
            return this.newCollectionMeta(target);
        }
        return new ObjectClassMeta(target, this.getBuilderInstantiator(target), this);
    }

    private Member getBuilderInstantiator(Type target) {
        String typeName = TypeHelper.toClass((Type)target).getName();
        UnaryFactory builderSupplier = (UnaryFactory)this.builderMethods.get(typeName);
        if (builderSupplier != null) {
            return (Member)builderSupplier.newInstance((Object)target);
        }
        return null;
    }

    public <T> ClassMeta<T> getClassMetaExtraInstantiator(Type target, Member builderInstantiator) {
        return new ObjectClassMeta(target, builderInstantiator, this);
    }

    private <K, V> ClassMeta<Map<K, V>> newMapMeta(Type type) {
        TypeHelper.MapEntryTypes types = TypeHelper.getKeyValueTypeOfMap((Type)type);
        return new MapClassMeta(type, types.getKeyType(), types.getValueType(), this);
    }

    private <T, E> ClassMeta<T> newArrayMeta(Class<T> clazz) {
        return ArrayClassMeta.of(clazz, clazz.getComponentType(), this);
    }

    private <T, E> ClassMeta<T> newCollectionMeta(Type type) {
        return ArrayClassMeta.of(type, TypeHelper.getComponentTypeOfListOrArray((Type)type), this);
    }

    private <T> boolean isFastTuple(Class<T> clazz) {
        Class<T> superClass = clazz.getSuperclass();
        return superClass != null && "com.boundary.tuple.FastTuple".equals(superClass.getName());
    }

    public String getColumnName(Method method) {
        return this.aliasProvider.getAliasForMethod(method);
    }

    public String getColumnName(Field field) {
        return this.aliasProvider.getAliasForField(field);
    }

    public List<InstantiatorDefinition> extractInstantiator(Type target) throws IOException {
        return this.extractInstantiator(target, null);
    }

    public List<InstantiatorDefinition> extractInstantiator(Type target, Member extraInstantiator) throws IOException {
        List<InstantiatorDefinition> list;
        if (!ReflectionInstantiatorDefinitionFactory.areParameterNamePresent(target)) {
            try {
                list = AsmInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IllegalArgumentException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
            catch (IOException e) {
                list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
            }
        } else {
            list = ReflectionInstantiatorDefinitionFactory.extractDefinitions(target);
        }
        if (TypeHelper.isKotlinClass((Type)target)) {
            this.kotlinReducationForDefaultValue(list);
        }
        if (extraInstantiator == null) {
            list.addAll(BuilderInstantiatorDefinitionFactory.extractDefinitions(target));
        } else if (extraInstantiator instanceof Method && TypeHelper.areEquals((Type)target, (Type)((Method)extraInstantiator).getGenericReturnType())) {
            list.add(ReflectionInstantiatorDefinitionFactory.definition((Method)extraInstantiator));
        } else {
            BuilderInstantiatorDefinition builder = BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(extraInstantiator, target);
            if (builder == null) {
                throw new IllegalArgumentException("Could not find any setters or build method on builder " + extraInstantiator);
            }
            list.add(builder);
        }
        Collections.sort(list, InstantiatorDefinitions.COMPARATOR);
        return list;
    }

    private void kotlinReducationForDefaultValue(List<InstantiatorDefinition> list) {
        List<ExecutableInstantiatorDefinition> potentialKotlinDefaultValue = this.kotlingDefaultValueConstructor(list);
        if (potentialKotlinDefaultValue.isEmpty()) {
            return;
        }
        list.removeAll(potentialKotlinDefaultValue);
        block0: for (int i = 0; i < potentialKotlinDefaultValue.size(); ++i) {
            ExecutableInstantiatorDefinition def = potentialKotlinDefaultValue.get(i);
            for (int j = 0; j < list.size(); ++j) {
                InstantiatorDefinition id = list.get(j);
                if (!this.isKotlinOriginalConstructor(def, id)) continue;
                list.set(j, new KotlinDefaultConstructorInstantiatorDefinition((ExecutableInstantiatorDefinition)id, def));
                continue block0;
            }
        }
    }

    private List<ExecutableInstantiatorDefinition> kotlingDefaultValueConstructor(List<InstantiatorDefinition> list) {
        ArrayList<ExecutableInstantiatorDefinition> potentialKotlinDefaultValue = new ArrayList<ExecutableInstantiatorDefinition>();
        for (int i = 0; i < list.size(); ++i) {
            Class<?>[] parameterTypes;
            Constructor c;
            InstantiatorDefinition id = list.get(i);
            if (!(id instanceof ExecutableInstantiatorDefinition) || !(((ExecutableInstantiatorDefinition)id).getExecutable() instanceof Constructor) || !(c = (Constructor)((ExecutableInstantiatorDefinition)id).getExecutable()).isSynthetic() || !(parameterTypes = c.getParameterTypes())[parameterTypes.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) continue;
            potentialKotlinDefaultValue.add((ExecutableInstantiatorDefinition)id);
        }
        return potentialKotlinDefaultValue;
    }

    private boolean isKotlinOriginalConstructor(ExecutableInstantiatorDefinition def, InstantiatorDefinition id) {
        ExecutableInstantiatorDefinition eid;
        if (id instanceof ExecutableInstantiatorDefinition && (eid = (ExecutableInstantiatorDefinition)id).getExecutable() instanceof Constructor) {
            int i;
            int syntheticParameters;
            int nbParams = eid.getParameters().length;
            if (nbParams + (syntheticParameters = nbParams / 32 + 1 + 1) != def.getParameters().length) {
                return false;
            }
            for (i = 0; i < nbParams; ++i) {
                if (def.getParameters()[i].getType().equals(id.getParameters()[i].getType())) continue;
                return false;
            }
            for (i = nbParams; i < nbParams + syntheticParameters - 1; ++i) {
                if (def.getParameters()[i].getType().equals(Integer.TYPE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static ReflectionService newInstance() {
        return ReflectionService.newInstance(true);
    }

    public static ReflectionService newInstance(boolean useAsmGeneration) {
        return new ReflectionService(useAsmGeneration && ReflectionService.canSeeSetterFromContextClassLoader() ? _asmFactory : null);
    }

    public static ReflectionService disableAsm() {
        return ReflectionService.newInstance(false);
    }

    private static boolean canSeeSetterFromContextClassLoader() {
        try {
            Class.forName(Setter.class.getName(), false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ObjectGetterFactory getObjectGetterFactory() {
        return this.objectGetterFactory;
    }

    public boolean hasAsmFactory() {
        return this.asmFactory != null;
    }

    public ReflectionService withAliasProvider(AliasProvider aliasProvider) {
        return new ReflectionService(this.objectSetterFactory, this.objectGetterFactory, this.instantiatorFactory, this.asmFactory, aliasProvider, this.builderIgnoresNullValues, this.selfScoreFullName);
    }

    public ReflectionService withBuilderIgnoresNullValues(boolean builderIgnoresNullValues) {
        return new ReflectionService(this.objectSetterFactory, this.objectGetterFactory, this.instantiatorFactory, this.asmFactory, this.aliasProvider, builderIgnoresNullValues, this.selfScoreFullName);
    }

    public ReflectionService withSelfScoreFullName(boolean selfScoreFullName) {
        return new ReflectionService(this.objectSetterFactory, this.objectGetterFactory, this.instantiatorFactory, this.asmFactory, this.aliasProvider, this.builderIgnoresNullValues, selfScoreFullName);
    }

    public boolean builderIgnoresNullValues() {
        return this.builderIgnoresNullValues;
    }

    public boolean selfScoreFullName() {
        return this.selfScoreFullName;
    }

    public void registerBuilder(String name, DefaultBuilderSupplier defaultBuilderSupplier) {
        this.builderMethods.put(name, defaultBuilderSupplier);
    }

    public static class DefaultBuilderSupplier
    implements UnaryFactory<Type, Member> {
        private final String clazzName;
        private final String methodName;

        public DefaultBuilderSupplier(String clazzName, String methodName) {
            this.clazzName = clazzName;
            this.methodName = methodName;
        }

        public Member newInstance(Type type) {
            try {
                Class<?> builderClazz = TypeHelper.toClass((Type)type).getClassLoader().loadClass(this.clazzName);
                if (this.methodName != null) {
                    return builderClazz.getMethod(this.methodName, new Class[0]);
                }
                return builderClazz.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                return (Member)ErrorHelper.rethrow((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                return (Member)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PassThrough {
        public String value() default "value";
    }

    public static interface BuilderProducer
    extends ProducerServiceLoader.Producer<Consumer<BiConsumer<String, UnaryFactory<Type, Member>>>> {
    }

    public static interface ClassMetaFactoryProducer
    extends ProducerServiceLoader.Producer<UnaryFactory<ReflectionService, ClassMeta<?>>> {
    }
}

