/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.InjectedParam;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.BiFactory;

public class BiInstantiatorKey {
    private final Object constructor;
    private final InjectedParam[] injectedParams;
    private final Class<?> s1;
    private final Class<?> s2;

    public BiInstantiatorKey(Object constructor, InjectedParam[] injectedParams, Class<?> s1, Class<?> s2) {
        this.constructor = constructor;
        this.injectedParams = injectedParams;
        this.s1 = s1;
        this.s2 = s2;
    }

    public BiInstantiatorKey(Class<?> target, Class<?> s1, Class<?> s2) throws NoSuchMethodException, SecurityException {
        this(target.getConstructor(new Class[0]), null, s1, s2);
    }

    public <S1, S2> BiInstantiatorKey(InstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, Class<?> s1, Class<?> s2) {
        this(BiInstantiatorKey.getConstructor(instantiatorDefinition), BiInstantiatorKey.paramAndBuilderFactoryClass(injections), s1, s2);
    }

    private static Object getConstructor(InstantiatorDefinition def) {
        if (def instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)def).getExecutable();
        }
        return ((BuilderInstantiatorDefinition)def).getBuildMethod();
    }

    private static <S1, S2> InjectedParam[] paramAndBuilderFactoryClass(Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections) {
        InjectedParam[] names = new InjectedParam[injections.size()];
        int i = 0;
        for (Map.Entry<Parameter, BiFactory<S1, S2, ?>> e : injections.entrySet()) {
            names[i++] = new InjectedParam(e.getKey().getName(), e.getValue().getClass());
        }
        Arrays.sort(names, new Comparator<InjectedParam>(){

            @Override
            public int compare(InjectedParam o1, InjectedParam o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return names;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 31 * result + Arrays.hashCode(this.injectedParams);
        result = 31 * result + (this.s1 == null ? 0 : this.s1.hashCode());
        result = 31 * result + (this.s2 == null ? 0 : this.s2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BiInstantiatorKey other = (BiInstantiatorKey)obj;
        if (this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor)) {
            return false;
        }
        if (!Arrays.equals(this.injectedParams, other.injectedParams)) {
            return false;
        }
        if (this.s1 == null ? other.s1 != null : !this.s1.equals(other.s1)) {
            return false;
        }
        return !(this.s2 == null ? other.s2 != null : !this.s2.equals(other.s2));
    }

    public Object getConstructor() {
        return this.constructor;
    }

    public String[] getInjectedParams() {
        if (this.injectedParams == null) {
            return new String[0];
        }
        String[] params = new String[this.injectedParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.injectedParams[i].getName();
        }
        return params;
    }

    public Class<?> getS1() {
        return this.s1;
    }

    public Class<?> getS2() {
        return this.s2;
    }

    public Class<?> getDeclaringClass() {
        if (this.constructor instanceof Member) {
            return ((Member)this.constructor).getDeclaringClass();
        }
        if (this.constructor instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)this.constructor).getExecutable().getDeclaringClass();
        }
        return ((BuilderInstantiatorDefinition)this.constructor).getBuildMethod().getDeclaringClass();
    }
}

