/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.BiFactory;
import org.simpleflatmapper.util.TypeHelper;

public class BiInstantiatorBuilder {
    public static final Class<BiInstantiator> BI_INSTANTIATOR_CLASS = BiInstantiator.class;
    public static final Class<Instantiator> INSTANTIATOR_CLASS = Instantiator.class;

    public static <S1, S2> byte[] createInstantiator(String className, Class<?> s1, Class<?> s2, ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String s1Type = AsmUtils.toWrapperType(s1);
        String s2Type = AsmUtils.toWrapperType(s2);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(BI_INSTANTIATOR_CLASS);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        Parameter[] parameters = instantiatorDefinition.getParameters();
        BiInstantiatorBuilder.appendFactory(injections, cw);
        BiInstantiatorBuilder.appendInit(injections, cw, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendNewInstance(s1, s2, instantiatorDefinition, injections, cw, targetType, s1Type, s2Type, classType, parameters);
        BiInstantiatorBuilder.appendBridgeMethod(cw, targetType, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendToString(injections, cw, parameters);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static <S1, S2> byte[] createInstantiator(String className, Class<?> s1, Class<?> s2, Instantiator<Void, ?> builderInstantiator, BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String s1Type = AsmUtils.toWrapperType(s1);
        String s2Type = AsmUtils.toWrapperType(s2);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(BI_INSTANTIATOR_CLASS);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        FieldVisitor fv = cw.visitField(16, "builderInstantiator", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;", null);
        fv.visitEnd();
        BiInstantiatorBuilder.appendFactory(injections, cw);
        BiInstantiatorBuilder.appendInitBuilder(injections, cw, s1Type, s2Type, classType, instantiatorDefinition);
        BiInstantiatorBuilder.appendNewInstance2(s1, s2, instantiatorDefinition, injections, cw, targetType, s1Type, s2Type, classType, instantiatorDefinition.getSetters());
        BiInstantiatorBuilder.appendBridgeMethod(cw, targetType, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendToString(injections, cw, instantiatorDefinition.getParameters());
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static <S1, S2> void appendFactory(Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw) {
        for (Map.Entry<Parameter, BiFactory<S1, S2, ?>> entry : injections.entrySet()) {
            FieldVisitor fv = cw.visitField(16, "factory_" + entry.getKey().getName(), AsmUtils.toTargetTypeDeclaration(entry.getValue().getClass()), null, null);
            fv.visitEnd();
        }
    }

    private static <S1, S2> void appendInitBuilder(Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw, String s1, String s2, String classType, BuilderInstantiatorDefinition instantiatorDefinition) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(BiFactory.class) + "<" + AsmUtils.toTargetTypeDeclaration(s1) + "*" + AsmUtils.toTargetTypeDeclaration(s2) + "*>;>;L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, classType, "builderInstantiator", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";");
        for (Map.Entry<Parameter, BiFactory<S1, S2, ?>> entry : injections.entrySet()) {
            String name = entry.getKey().getName();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(name);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, AsmUtils.toAsmType(entry.getValue().getClass()));
            mv.visitFieldInsn(181, classType, "factory_" + name, AsmUtils.toTargetTypeDeclaration(entry.getValue().getClass()));
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendInit(Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw, String s1, String s2, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(BiFactory.class) + "<" + AsmUtils.toTargetTypeDeclaration(s1) + "*" + AsmUtils.toTargetTypeDeclaration(s2) + "*>;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        for (Map.Entry<Parameter, BiFactory<S1, S2, ?>> entry : injections.entrySet()) {
            String name = entry.getKey().getName();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(name);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, AsmUtils.toAsmType(entry.getValue().getClass()));
            mv.visitFieldInsn(181, classType, "factory_" + name, AsmUtils.toTargetTypeDeclaration(entry.getValue().getClass()));
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendNewInstance(Class<?> s1, Class<?> s2, ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw, String targetType, String s1Type, String s2Type, String classType, Parameter[] parameters) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitTypeInsn(187, targetType);
        mv.visitInsn(89);
        StringBuilder sb = new StringBuilder();
        for (Parameter p : parameters) {
            BiFactory<? super S1, ? super S2, ?> factory = injections.get(p);
            sb.append(AsmUtils.toTargetTypeDeclaration(p.getType()));
            if (factory == null) {
                if (TypeHelper.isPrimitive(p.getType())) {
                    mv.visitInsn(AsmUtils.defaultValue.get(p.getType()));
                    continue;
                }
                mv.visitInsn(1);
                continue;
            }
            BiInstantiatorBuilder.invovkeFactory(p, factory, classType, s1, s2, mv);
        }
        Member exec = instantiatorDefinition.getExecutable();
        if (exec instanceof Constructor) {
            mv.visitMethodInsn(183, targetType, "<init>", "(" + sb.toString() + ")V", false);
        } else {
            mv.visitMethodInsn(184, AsmUtils.toAsmType(((Method)exec).getDeclaringClass()), exec.getName(), AsmUtils.toSignature((Method)exec), false);
        }
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void invovkeFactory(Parameter p, BiFactory<S1, S2, ?> factory, String classType, Class<?> s1, Class<?> s2, MethodVisitor mv) throws NoSuchMethodException {
        String getterType = AsmUtils.toAsmType(factory.getClass());
        String s1Type = AsmUtils.toAsmType(s1.equals(Void.class) || s1.equals(Void.TYPE) ? Object.class : s1);
        String s2Type = AsmUtils.toAsmType(s2.equals(Void.class) || s2.equals(Void.TYPE) ? Object.class : s2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, "factory_" + p.getName(), AsmUtils.toTargetTypeDeclaration(getterType));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        Class<?> wrapperClass = AsmUtils.toWrapperClass(p.getType());
        Method getterMethod = BiInstantiatorBuilder.getNewInstanceMethod(factory.getClass());
        AsmUtils.invoke(mv, factory.getClass(), getterMethod);
        if (!wrapperClass.isAssignableFrom(getterMethod.getReturnType())) {
            mv.visitTypeInsn(192, AsmUtils.toAsmType(wrapperClass));
        }
        if (TypeHelper.isPrimitive(p.getType())) {
            String methodSuffix = BiInstantiatorBuilder.getPrimitiveMethodSuffix(p);
            String valueMethodPrefix = methodSuffix.toLowerCase();
            if ("character".equals(valueMethodPrefix)) {
                valueMethodPrefix = "char";
            }
            String valueMethod = valueMethodPrefix + "Value";
            AsmUtils.invoke(mv, wrapperClass, valueMethod, "()" + AsmUtils.toAsmType(p.getType()));
        }
    }

    private static Method getNewInstanceMethod(Class<? extends BiFactory> aClass) {
        Method m = null;
        for (Method p : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(p.getModifiers()) || !p.getName().equals("newInstance") || p.getParameterTypes() == null || p.getParameterTypes().length != 2 || m != null && p.getModifiers() >= m.getModifiers()) continue;
            m = p;
        }
        return m;
    }

    private static String getPrimitiveMethodSuffix(Parameter p) {
        return BiInstantiatorBuilder.getPrimitiveMethodSuffix(p.getType());
    }

    private static String getPrimitiveMethodSuffix(Class<?> type) {
        String methodSuffix = AsmUtils.wrappers.get(type).getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        return methodSuffix;
    }

    private static <S1, S2> void appendNewInstance2(Class<?> s1, Class<?> s2, BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw, String targetType, String s1Type, String s2Type, String classType, Map<Parameter, Method> setters) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, "builderInstantiator", AsmUtils.toTargetTypeDeclaration(INSTANTIATOR_CLASS));
        mv.visitInsn(1);
        mv.visitMethodInsn(185, AsmUtils.toAsmType(INSTANTIATOR_CLASS), "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        Type builderClass = BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator());
        String builderType = AsmUtils.toAsmType(builderClass);
        mv.visitTypeInsn(192, builderType);
        mv.visitVarInsn(58, 2);
        for (Map.Entry<Parameter, Method> e : setters.entrySet()) {
            mv.visitVarInsn(25, 2);
            Parameter p = e.getKey();
            BiFactory<? super S1, ? super S2, ?> factory = injections.get(p);
            if (factory == null) {
                if (TypeHelper.isPrimitive(p.getType())) {
                    mv.visitInsn(AsmUtils.defaultValue.get(p.getType()));
                    continue;
                }
                mv.visitInsn(1);
                continue;
            }
            BiInstantiatorBuilder.invovkeFactory(p, factory, classType, s1, s2, mv);
            AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), e.getValue().getName(), AsmUtils.toSignature(e.getValue()));
            if (Void.TYPE.equals(e.getValue().getReturnType())) continue;
            mv.visitVarInsn(58, 2);
        }
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), instantiatorDefinition.getBuildMethod().getName(), AsmUtils.toSignature(instantiatorDefinition.getBuildMethod()));
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static void appendBridgeMethod(ClassWriter cw, String targetType, String s1Type, String s2Type, String classType) {
        MethodVisitor mv = cw.visitMethod(4161, "newInstance", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, s1Type);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, s2Type);
        mv.visitMethodInsn(182, classType, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendToString(Map<Parameter, BiFactory<? super S1, ? super S2, ?>> injections, ClassWriter cw, Parameter[] parameters) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = (i > 0 ? ", " : "") + "parameter" + i + "=";
            String parameter = String.valueOf(parameters[i]);
            mv.visitLdcInsn(paramName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(parameter);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            BiFactory<? super S1, ? super S2, ?> biFactory = injections.get(parameters[i]);
            String getterName = ", parameter" + i + "=";
            String getterString = String.valueOf(biFactory);
            mv.visitLdcInsn(getterName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(getterString);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn("}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private static Type getTargetType(InstantiatorDefinition instantiatorDefinition) {
        switch (instantiatorDefinition.getType()) {
            case METHOD: {
                return ((Method)((ExecutableInstantiatorDefinition)instantiatorDefinition).getExecutable()).getGenericReturnType();
            }
            case CONSTRUCTOR: {
                return ((Constructor)((ExecutableInstantiatorDefinition)instantiatorDefinition).getExecutable()).getDeclaringClass();
            }
            case BUILDER: {
                return ((BuilderInstantiatorDefinition)instantiatorDefinition).getBuildMethod().getGenericReturnType();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)instantiatorDefinition.getType()));
    }
}

