/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.BooleanProvider;

final class ObjectPropertyFinder<T>
extends PropertyFinder<T> {
    private final List<InstantiatorDefinition> eligibleInstantiatorDefinitions;
    private final ObjectClassMeta<T> classMeta;
    private final Map<String, PropertyFinder<?>> subPropertyFinders = new HashMap();
    private State state = State.NONE;
    private String selfName;

    ObjectPropertyFinder(ObjectClassMeta<T> classMeta) {
        this.classMeta = classMeta;
        this.eligibleInstantiatorDefinitions = classMeta.getInstantiatorDefinitions() != null ? new ArrayList<InstantiatorDefinition>(classMeta.getInstantiatorDefinitions()) : null;
    }

    @Override
    protected void lookForProperties(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference) {
        this.lookForConstructor(propertyNameMatcher, matchingProperties, score);
        this.lookForProperty(propertyNameMatcher, matchingProperties, score);
        final String propName = propertyNameMatcher.toString();
        if (allowSelfReference && (this.state == State.NONE || this.state == State.SELF && propName.equals(this.selfName))) {
            matchingProperties.found(new SelfPropertyMeta(this.classMeta.getReflectionService(), this.classMeta.getType(), new BooleanProvider(){

                public boolean getBoolean() {
                    return ObjectPropertyFinder.this.state != State.PROPERTIES;
                }
            }), new Runnable(){

                @Override
                public void run() {
                    ObjectPropertyFinder.this.state = State.SELF;
                    ObjectPropertyFinder.this.selfName = propName;
                }
            }, PropertyMatchingScore.MINIMUM);
        }
    }

    private void lookForConstructor(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score) {
        if (this.classMeta.getConstructorProperties() != null) {
            for (final ConstructorPropertyMeta<T, ?> prop : this.classMeta.getConstructorProperties()) {
                PropertyNameMatcher subPropMatcher;
                String columnName = this.getColumnName(prop);
                if (propertyNameMatcher.matches(columnName) && this.hasConstructorMatching(prop.getParameter())) {
                    matchingProperties.found(prop, new Runnable(){

                        @Override
                        public void run() {
                            ObjectPropertyFinder.this.removeNonMatching(prop.getParameter());
                            ObjectPropertyFinder.this.state = State.PROPERTIES;
                        }
                    }, score);
                }
                if ((subPropMatcher = propertyNameMatcher.partialMatch(columnName)) == null || !this.hasConstructorMatching(prop.getParameter())) continue;
                this.lookForSubProperty(subPropMatcher, prop, new PropertyFinder.FoundProperty(){

                    public void found(PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                        matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), new Runnable(){

                            @Override
                            public void run() {
                                selectionCallback.run();
                                ObjectPropertyFinder.this.removeNonMatching(prop.getParameter());
                                ObjectPropertyFinder.this.state = State.PROPERTIES;
                            }
                        }, score.shift());
                    }
                }, score.shift());
            }
        }
    }

    private void lookForProperty(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score) {
        for (final PropertyMeta<T, ?> prop : this.classMeta.getProperties()) {
            PropertyNameMatcher subPropMatcher;
            String columnName = this.getColumnName(prop);
            if (propertyNameMatcher.matches(columnName)) {
                matchingProperties.found(prop, new Runnable(){

                    @Override
                    public void run() {
                        ObjectPropertyFinder.this.state = State.PROPERTIES;
                    }
                }, score.decrease(1));
            }
            if ((subPropMatcher = propertyNameMatcher.partialMatch(columnName)) == null) continue;
            this.lookForSubProperty(subPropMatcher, prop, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                    matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), new Runnable(){

                        @Override
                        public void run() {
                            selectionCallback.run();
                            ObjectPropertyFinder.this.state = State.PROPERTIES;
                        }
                    }, score);
                }
            }, score.shift().decrease(-1));
        }
    }

    private void lookForSubProperty(PropertyNameMatcher propertyNameMatcher, PropertyMeta<T, ?> prop, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score) {
        PropertyFinder<?> subPropertyFinder = this.subPropertyFinders.get(this.getColumnName(prop));
        if (subPropertyFinder == null) {
            subPropertyFinder = prop.getPropertyClassMeta().newPropertyFinder();
            this.subPropertyFinders.put(prop.getName(), subPropertyFinder);
        }
        subPropertyFinder.lookForProperties(propertyNameMatcher, foundProperty, score, false);
    }

    private String getColumnName(PropertyMeta<T, ?> prop) {
        return this.classMeta.getAlias(prop.getName());
    }

    private void removeNonMatching(Parameter param) {
        ListIterator<InstantiatorDefinition> li = this.eligibleInstantiatorDefinitions.listIterator();
        while (li.hasNext()) {
            InstantiatorDefinition cd = li.next();
            if (cd.hasParam(param)) continue;
            li.remove();
        }
    }

    private boolean hasConstructorMatching(Parameter param) {
        for (InstantiatorDefinition cd : this.eligibleInstantiatorDefinitions) {
            if (!cd.hasParam(param)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.eligibleInstantiatorDefinitions;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return this.subPropertyFinders.get(name);
    }

    static enum State {
        NONE,
        SELF,
        PROPERTIES;

    }
}

