/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;

public class ArrayElementPropertyMeta<T, E>
extends PropertyMeta<T, E> {
    private final int index;
    private final ArrayClassMeta<T, E> arrayMetaData;
    private final Setter<T, E> setter;
    private final Getter<T, E> getter;

    public ArrayElementPropertyMeta(String name, Type ownerType, ReflectionService reflectService, int index, ArrayClassMeta<T, E> arrayMetaData) {
        super(name, ownerType, reflectService);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid array index " + index);
        }
        this.index = index;
        this.arrayMetaData = arrayMetaData;
        this.setter = new IndexArraySetter(index);
        this.getter = new IndexArrayGetter(index);
    }

    @Override
    public Setter<T, E> getSetter() {
        return this.setter;
    }

    @Override
    public Getter<T, E> getGetter() {
        return this.getter;
    }

    @Override
    public Type getPropertyType() {
        return this.arrayMetaData.getElementTarget();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        return this.index + "." + this.getName();
    }

    public String toString() {
        return "ArrayElementPropertyMeta{index=" + this.index + '}';
    }

    private static class IndexArrayGetter<E>
    implements Getter<E[], E> {
        private final int index;

        private IndexArrayGetter(int index) {
            this.index = index;
        }

        @Override
        public E get(E[] target) throws Exception {
            return target[this.index];
        }
    }

    private static class IndexArraySetter<E>
    implements Setter<E[], E> {
        private final int index;

        private IndexArraySetter(int index) {
            this.index = index;
        }

        @Override
        public void set(E[] target, E value) throws Exception {
            target[this.index] = value;
        }
    }
}

