/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.Label;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.asm.BiInstantiatorBuilder;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;

public class InstantiatorBuilder {
    public static <S> byte[] createInstantiator(String className, Class<?> sourceClass, ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String sourceType = AsmUtils.toWrapperType(sourceClass);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(Instantiator.class);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        Parameter[] parameters = instantiatorDefinition.getParameters();
        InstantiatorBuilder.appendGetters(injections, cw);
        InstantiatorBuilder.appendInit(injections, cw, sourceType, classType);
        InstantiatorBuilder.appendNewInstanceBuilderOnMethod(sourceClass, instantiatorDefinition, injections, cw, targetType, sourceType, classType, parameters);
        InstantiatorBuilder.appendBridgeMethod(cw, targetType, sourceType, classType);
        InstantiatorBuilder.appendToString(injections, cw, parameters);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    public static <S> byte[] createInstantiator(String className, Class<?> sourceClass, BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, boolean ignoreNullValues) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String sourceType = AsmUtils.toWrapperType(sourceClass);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(Instantiator.class);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        FieldVisitor fv = cw.visitField(16, "builderInstantiator", "L" + AsmUtils.toAsmType(Instantiator.class) + ";", "L" + AsmUtils.toAsmType(Instantiator.class) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;", null);
        fv.visitEnd();
        InstantiatorBuilder.appendGetters(injections, cw);
        InstantiatorBuilder.appendInitBuilder(injections, cw, sourceType, classType, instantiatorDefinition);
        InstantiatorBuilder.appendNewInstanceBuilderOnBuilder(sourceClass, instantiatorDefinition, injections, cw, targetType, sourceType, classType, instantiatorDefinition.getSetters(), ignoreNullValues);
        InstantiatorBuilder.appendBridgeMethod(cw, targetType, sourceType, classType);
        InstantiatorBuilder.appendToString(injections, cw, instantiatorDefinition.getParameters());
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static <S> void appendGetters(Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw) {
        for (Map.Entry<Parameter, Getter<S, ?>> entry : injections.entrySet()) {
            GetterCall getterCall = InstantiatorBuilder.getGetterCall(entry.getKey().getType(), entry.getValue().getClass());
            FieldVisitor fv = cw.visitField(16, "getter_" + entry.getKey().getName(), AsmUtils.toTargetTypeDeclaration(getterCall.getterType), null, null);
            fv.visitEnd();
        }
    }

    private static <S> void appendInitBuilder(Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw, String sourceType, String classType, BuilderInstantiatorDefinition instantiatorDefinition) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;L" + AsmUtils.toAsmType(Instantiator.class) + ";)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(Getter.class) + "<" + AsmUtils.toTargetTypeDeclaration(sourceType) + "*>;>;L" + AsmUtils.toAsmType(Instantiator.class) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, classType, "builderInstantiator", "L" + AsmUtils.toAsmType(Instantiator.class) + ";");
        InstantiatorBuilder.appendInitGetters(injections, classType, mv);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S> void appendInitGetters(Map<Parameter, Getter<? super S, ?>> injections, String classType, MethodVisitor mv) {
        for (Map.Entry<Parameter, Getter<S, ?>> entry : injections.entrySet()) {
            String name = entry.getKey().getName();
            GetterCall getterCall = InstantiatorBuilder.getGetterCall(entry.getKey().getType(), entry.getValue().getClass());
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(name);
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, AsmUtils.toAsmType(getterCall.getterType));
            mv.visitFieldInsn(181, classType, "getter_" + name, AsmUtils.toTargetTypeDeclaration(getterCall.getterType));
        }
    }

    private static <S> void appendInit(Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw, String sourceType, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(Getter.class) + "<" + AsmUtils.toTargetTypeDeclaration(sourceType) + "*>;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        InstantiatorBuilder.appendInitGetters(injections, classType, mv);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S> void appendNewInstanceBuilderOnMethod(Class<?> sourceClass, ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw, String targetType, String sourceType, String classType, Parameter[] parameters) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(sourceType) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        if (!Modifier.isStatic(instantiatorDefinition.getExecutable().getModifiers())) {
            mv.visitTypeInsn(187, targetType);
            mv.visitInsn(89);
        }
        StringBuilder sb = new StringBuilder();
        for (Parameter p : parameters) {
            Getter<? super S, ?> getter = injections.get(p);
            sb.append(AsmUtils.toTargetTypeDeclaration(p.getType()));
            if (getter == null) {
                if (TypeHelper.isPrimitive(p.getType())) {
                    mv.visitInsn(AsmUtils.defaultValue.get(p.getType()));
                    continue;
                }
                mv.visitInsn(1);
                continue;
            }
            InstantiatorBuilder.invokeGetter(p, getter, classType, sourceClass, mv, null, false);
        }
        Member exec = instantiatorDefinition.getExecutable();
        if (exec instanceof Constructor) {
            mv.visitMethodInsn(183, targetType, "<init>", "(" + sb.toString() + ")V", false);
        } else {
            mv.visitMethodInsn(184, AsmUtils.toAsmType(((Method)exec).getDeclaringClass()), exec.getName(), AsmUtils.toSignature((Method)exec), false);
        }
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S> void invokeGetter(Parameter p, Getter<? super S, ?> getter, String classType, Class<?> sourceClass, MethodVisitor mv, Consumer<MethodVisitor> consumer, boolean ignoreNullValues) throws NoSuchMethodException {
        GetterCall getterCall = InstantiatorBuilder.getGetterCall(p.getType(), getter.getClass());
        String getterType = AsmUtils.toAsmType(getterCall.getterType);
        String sourceType = AsmUtils.toAsmType(sourceClass.equals(Void.class) || sourceClass.equals(Void.TYPE) ? Object.class : sourceClass);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, "getter_" + p.getName(), AsmUtils.toTargetTypeDeclaration(getterType));
        mv.visitVarInsn(25, 1);
        if (getterCall.isPrimitive) {
            AsmUtils.invoke(mv, getterCall.getterType, getterCall.methodName, "(" + AsmUtils.toTargetTypeDeclaration(sourceType) + ")" + AsmUtils.toAsmType(p.getType()));
            if (consumer != null) {
                consumer.accept((Object)mv);
            }
        } else {
            Class<?> wrapperClass = AsmUtils.toWrapperClass(p.getType());
            Method getterMethod = BiInstantiatorBuilder.getMethod(TypeHelper.toClass((Type)getterCall.getterType), "get", 1);
            AsmUtils.invoke(mv, getterCall.getterType, getterMethod);
            if (!wrapperClass.isAssignableFrom(getterMethod.getReturnType())) {
                mv.visitTypeInsn(192, AsmUtils.toAsmType(wrapperClass));
            }
            Label label = new Label();
            if (ignoreNullValues) {
                mv.visitVarInsn(58, 3);
                mv.visitVarInsn(25, 3);
                mv.visitJumpInsn(198, label);
            }
            InstantiatorBuilder.changeToPrimitiveIfNeeded(p, mv, wrapperClass, ignoreNullValues);
            if (consumer != null) {
                consumer.accept((Object)mv);
            }
            if (ignoreNullValues) {
                mv.visitLabel(label);
            }
        }
    }

    private static void changeToPrimitiveIfNeeded(Parameter p, MethodVisitor mv, Class<?> wrapperClass, boolean ignoreNullValues) {
        if (TypeHelper.isPrimitive(p.getType())) {
            String methodSuffix;
            String valueMethodPrefix;
            if (ignoreNullValues) {
                mv.visitVarInsn(25, 3);
            }
            if ("character".equals(valueMethodPrefix = (methodSuffix = InstantiatorBuilder.getPrimitiveMethodSuffix(p)).toLowerCase())) {
                valueMethodPrefix = "char";
            }
            String valueMethod = valueMethodPrefix + "Value";
            AsmUtils.invoke(mv, wrapperClass, valueMethod, "()" + AsmUtils.toAsmType(p.getType()));
            if (ignoreNullValues) {
                mv.visitVarInsn(AsmUtils.getStoreOps(p.getType()), 3);
            }
        }
    }

    private static String getPrimitiveMethodSuffix(Parameter p) {
        return InstantiatorBuilder.getPrimitiveMethodSuffix(p.getType());
    }

    private static String getPrimitiveMethodSuffix(Class<?> type) {
        String methodSuffix = AsmUtils.wrappers.get(type).getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        return methodSuffix;
    }

    private static <S> void appendNewInstanceBuilderOnBuilder(Class<?> sourceClass, BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw, String targetType, String sourceType, String classType, Map<Parameter, Method> setters, boolean ignoreNullValues) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(sourceType) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, "builderInstantiator", AsmUtils.toTargetTypeDeclaration(Instantiator.class));
        mv.visitInsn(1);
        mv.visitMethodInsn(185, AsmUtils.toAsmType(Instantiator.class), "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        final Type builderClass = BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator());
        String builderType = AsmUtils.toAsmType(builderClass);
        mv.visitTypeInsn(192, builderType);
        mv.visitVarInsn(58, 2);
        boolean first = true;
        for (final Map.Entry<Parameter, Method> e : setters.entrySet()) {
            Parameter p = e.getKey();
            Getter<S, ?> getter = injections.get(p);
            if (getter == null) continue;
            final Class<?> parameterType = p.getType();
            final boolean checkIfNull = ignoreNullValues && !InstantiatorBuilder.getGetterCall(parameterType, getter.getClass()).isPrimitive;
            mv.visitVarInsn(25, 2);
            InstantiatorBuilder.invokeGetter(p, getter, classType, sourceClass, mv, new Consumer<MethodVisitor>(){

                public void accept(MethodVisitor mv) {
                    if (checkIfNull) {
                        mv.visitVarInsn(25, 2);
                        mv.visitVarInsn(AsmUtils.getLoadOps(parameterType), 3);
                    }
                    AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), ((Method)e.getValue()).getName(), AsmUtils.toSignature((Method)e.getValue()));
                    if (!Void.TYPE.equals(((Method)e.getValue()).getReturnType())) {
                        mv.visitVarInsn(58, 2);
                    }
                }
            }, ignoreNullValues);
            if (!checkIfNull) continue;
            if (first && !Void.TYPE.equals(e.getValue().getReturnType())) {
                mv.visitFrame(1, 1, new Object[]{builderType}, 0, null);
            } else {
                mv.visitFrame(3, 0, null, 0, null);
            }
            first = false;
        }
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), instantiatorDefinition.getBuildMethod().getName(), AsmUtils.toSignature(instantiatorDefinition.getBuildMethod()));
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static GetterCall getGetterCall(Class<?> propertyType, Class<? extends Getter> getterClass) {
        if (TypeHelper.isPrimitive(propertyType)) {
            Class<?> primitiveGetter = BiInstantiatorBuilder.getPrimitiveGetter(propertyType);
            if (primitiveGetter == null) {
                throw new IllegalStateException("No primitive getter for primitive " + propertyType);
            }
            Type publicGetterClass = AsmUtils.findClosestPublicTypeExposing(getterClass, primitiveGetter);
            if (publicGetterClass != null) {
                return new GetterCall("get" + InstantiatorBuilder.getPrimitiveMethodSuffix(propertyType), publicGetterClass, true);
            }
        }
        Type publicGetterClass = AsmUtils.findClosestPublicTypeExposing(getterClass, Getter.class);
        return new GetterCall("get", publicGetterClass, false);
    }

    private static void appendBridgeMethod(ClassWriter cw, String targetType, String sourceType, String classType) {
        MethodVisitor mv = cw.visitMethod(4161, "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, sourceType);
        mv.visitMethodInsn(182, classType, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(sourceType) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static <S> void appendToString(Map<Parameter, Getter<? super S, ?>> injections, ClassWriter cw, Parameter[] parameters) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = (i > 0 ? ", " : "") + "parameter" + i + "=";
            String parameter = String.valueOf(parameters[i]);
            mv.visitLdcInsn(paramName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(parameter);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            Getter<? super S, ?> getter = injections.get(parameters[i]);
            String getterName = ", parameter" + i + "=";
            String getterString = String.valueOf(getter);
            mv.visitLdcInsn(getterName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(getterString);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn("}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    static class GetterCall {
        final String methodName;
        final Type getterType;
        final boolean isPrimitive;

        GetterCall(String methodName, Type getterType, boolean isPrimitive) {
            this.methodName = methodName;
            this.getterType = getterType;
            this.isPrimitive = isPrimitive;
        }
    }
}

